/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.ObjectExistsException;
import net.sf.ehcache.Status;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.config.ConfigurationFactory;
import net.sf.ehcache.config.ConfigurationHelper;
import net.sf.ehcache.distribution.CacheManagerPeerListener;
import net.sf.ehcache.distribution.CacheManagerPeerProvider;
import net.sf.ehcache.event.CacheManagerEventListener;
import net.sf.ehcache.event.CacheManagerEventListenerRegistry;
import net.sf.ehcache.store.DiskStore;
import net.sf.ehcache.util.PropertyUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CacheManager {
    public static final List ALL_CACHE_MANAGERS = Collections.synchronizedList(new ArrayList());
    public static final String ENABLE_SHUTDOWN_HOOK_PROPERTY = "net.sf.ehcache.enableShutdownHook";
    private static final Log LOG = LogFactory.getLog((String)CacheManager.class.getName());
    private static CacheManager singleton;
    protected final Map caches = new HashMap();
    private Ehcache defaultCache;
    private String diskStorePath;
    private String name;
    private Status status;
    private CacheManagerPeerProvider cacheManagerPeerProvider;
    private CacheManagerPeerListener cacheManagerPeerListener;
    private CacheManagerEventListenerRegistry cacheManagerEventListenerRegistry = new CacheManagerEventListenerRegistry();
    private Thread shutdownHook;

    public CacheManager(Configuration configuration) throws CacheException {
        this.status = Status.STATUS_UNINITIALISED;
        this.init(configuration, null, null, null);
    }

    public CacheManager(String configurationFileName) throws CacheException {
        this.status = Status.STATUS_UNINITIALISED;
        this.init(null, configurationFileName, null, null);
    }

    public CacheManager(URL configurationURL) throws CacheException {
        this.status = Status.STATUS_UNINITIALISED;
        this.init(null, null, configurationURL, null);
    }

    public CacheManager(InputStream configurationInputStream) throws CacheException {
        this.status = Status.STATUS_UNINITIALISED;
        this.init(null, null, null, configurationInputStream);
    }

    public CacheManager() throws CacheException {
        this.status = Status.STATUS_UNINITIALISED;
        this.init(null, null, null, null);
    }

    private void init(Configuration configuration, String configurationFileName, URL configurationURL, InputStream configurationInputStream) {
        Configuration localConfiguration = configuration;
        if (configuration == null) {
            localConfiguration = this.parseConfiguration(configurationFileName, configurationURL, configurationInputStream);
        } else {
            localConfiguration.setSource("Programmatically configured.");
        }
        ConfigurationHelper configurationHelper = new ConfigurationHelper(this, localConfiguration);
        this.configure(configurationHelper);
        this.status = Status.STATUS_ALIVE;
        if (this.cacheManagerPeerProvider != null) {
            this.cacheManagerPeerProvider.init();
        }
        this.cacheManagerEventListenerRegistry.init();
        this.addShutdownHookIfRequired();
        this.addConfiguredCaches(configurationHelper);
    }

    private synchronized Configuration parseConfiguration(String configurationFileName, URL configurationURL, InputStream configurationInputStream) throws CacheException {
        String configurationSource;
        Configuration configuration;
        this.reinitialisationCheck();
        if (configurationFileName != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Configuring CacheManager from " + configurationFileName));
            }
            configuration = ConfigurationFactory.parseConfiguration(new File(configurationFileName));
            configurationSource = "file located at " + configurationFileName;
        } else if (configurationURL != null) {
            configuration = ConfigurationFactory.parseConfiguration(configurationURL);
            configurationSource = "URL of " + configurationURL;
        } else if (configurationInputStream != null) {
            configuration = ConfigurationFactory.parseConfiguration(configurationInputStream);
            configurationSource = "InputStream " + configurationInputStream;
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Configuring ehcache from classpath.");
            }
            configuration = ConfigurationFactory.parseConfiguration();
            configurationSource = "classpath";
        }
        configuration.setSource(configurationSource);
        return configuration;
    }

    private void configure(ConfigurationHelper configurationHelper) {
        this.diskStorePath = configurationHelper.getDiskStorePath();
        this.detectAndFixDiskStorePathConflict(configurationHelper);
        this.cacheManagerEventListenerRegistry.registerListener(configurationHelper.createCacheManagerEventListener());
        this.cacheManagerPeerListener = configurationHelper.createCachePeerListener();
        this.cacheManagerEventListenerRegistry.registerListener(this.cacheManagerPeerListener);
        this.detectAndFixCacheManagerPeerListenerConflict(configurationHelper);
        ALL_CACHE_MANAGERS.add(this);
        this.cacheManagerPeerProvider = configurationHelper.createCachePeerProvider();
        this.defaultCache = configurationHelper.createDefaultCache();
    }

    private void detectAndFixDiskStorePathConflict(ConfigurationHelper configurationHelper) {
        if (this.diskStorePath == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"No disk store path defined. Skipping disk store path conflict test.");
            }
            return;
        }
        for (int i = 0; i < ALL_CACHE_MANAGERS.size(); ++i) {
            CacheManager cacheManager = (CacheManager)ALL_CACHE_MANAGERS.get(i);
            if (!this.diskStorePath.equals(cacheManager.diskStorePath)) continue;
            String newDiskStorePath = this.diskStorePath + File.separator + DiskStore.generateUniqueDirectory();
            LOG.warn((Object)("Creating a new instance of CacheManager using the diskStorePath \"" + this.diskStorePath + "\" which is already used" + " by an existing CacheManager.\nThe source of the configuration was " + configurationHelper.getConfigurationBean().getConfigurationSource() + ".\n" + "The diskStore path for this CacheManager will be set to " + newDiskStorePath + ".\nTo avoid this" + " warning consider using the CacheManager factory methods to create a singleton CacheManager " + "or specifying a separate ehcache configuration (ehcache.xml) for each CacheManager instance."));
            this.diskStorePath = newDiskStorePath;
            break;
        }
    }

    private void detectAndFixCacheManagerPeerListenerConflict(ConfigurationHelper configurationHelper) {
        if (this.cacheManagerPeerListener == null) {
            return;
        }
        String uniqueResourceIdentifier = this.cacheManagerPeerListener.getUniqueResourceIdentifier();
        for (int i = 0; i < ALL_CACHE_MANAGERS.size(); ++i) {
            String otherUniqueResourceIdentifier;
            CacheManager cacheManager = (CacheManager)ALL_CACHE_MANAGERS.get(i);
            CacheManagerPeerListener otherCacheManagerPeerListener = cacheManager.cacheManagerPeerListener;
            if (otherCacheManagerPeerListener == null || !uniqueResourceIdentifier.equals(otherUniqueResourceIdentifier = otherCacheManagerPeerListener.getUniqueResourceIdentifier())) continue;
            LOG.warn((Object)("Creating a new instance of CacheManager with a CacheManagerPeerListener which has a conflict on a resource that must be unique.\nThe resource is " + uniqueResourceIdentifier + ".\n" + "Attempting automatic resolution. The source of the configuration was " + configurationHelper.getConfigurationBean().getConfigurationSource() + ".\n" + "To avoid this warning consider using the CacheManager factory methods to create a " + "singleton CacheManager " + "or specifying a separate ehcache configuration (ehcache.xml) for each CacheManager instance."));
            this.cacheManagerPeerListener.attemptResolutionOfUniqueResourceConflict();
            break;
        }
    }

    private void addConfiguredCaches(ConfigurationHelper configurationHelper) {
        Set unitialisedCaches = configurationHelper.createCaches();
        Iterator iterator = unitialisedCaches.iterator();
        while (iterator.hasNext()) {
            Ehcache unitialisedCache = (Ehcache)iterator.next();
            this.addCacheNoCheck(unitialisedCache);
        }
    }

    private void reinitialisationCheck() throws IllegalStateException {
        if (this.defaultCache != null || this.diskStorePath != null || this.caches.size() != 0 || this.status.equals(Status.STATUS_SHUTDOWN)) {
            throw new IllegalStateException("Attempt to reinitialise the CacheManager");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CacheManager create() throws CacheException {
        Class clazz = CacheManager.class;
        synchronized (clazz) {
            if (singleton == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Creating new CacheManager with default config");
                }
                singleton = new CacheManager();
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Attempting to create an existing singleton. Existing singleton returned.");
            }
            return singleton;
        }
    }

    public static CacheManager getInstance() throws CacheException {
        return CacheManager.create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CacheManager create(String configurationFileName) throws CacheException {
        Class clazz = CacheManager.class;
        synchronized (clazz) {
            if (singleton == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Creating new CacheManager with config file: " + configurationFileName));
                }
                singleton = new CacheManager(configurationFileName);
            }
            return singleton;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CacheManager create(URL configurationFileURL) throws CacheException {
        Class clazz = CacheManager.class;
        synchronized (clazz) {
            if (singleton == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Creating new CacheManager with config URL: " + configurationFileURL));
                }
                singleton = new CacheManager(configurationFileURL);
            }
            return singleton;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CacheManager create(InputStream inputStream) throws CacheException {
        Class clazz = CacheManager.class;
        synchronized (clazz) {
            if (singleton == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Creating new CacheManager with InputStream");
                }
                singleton = new CacheManager(inputStream);
            }
            return singleton;
        }
    }

    public synchronized Cache getCache(String name) throws IllegalStateException, ClassCastException {
        this.checkStatus();
        return (Cache)this.caches.get(name);
    }

    public synchronized Ehcache getEhcache(String name) throws IllegalStateException {
        this.checkStatus();
        return (Ehcache)this.caches.get(name);
    }

    private void addShutdownHookIfRequired() {
        String shutdownHookProperty = System.getProperty(ENABLE_SHUTDOWN_HOOK_PROPERTY);
        boolean enabled = PropertyUtil.parseBoolean(shutdownHookProperty);
        if (!enabled) {
            return;
        }
        LOG.info((Object)"The CacheManager shutdown hook is enabled because net.sf.ehcache.enableShutdownHook is set to true.");
        Thread localShutdownHook = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                1 var1_1 = this;
                synchronized (var1_1) {
                    if (CacheManager.this.status.equals(Status.STATUS_ALIVE)) {
                        CacheManager.this.shutdownHook = null;
                        if (LOG.isInfoEnabled()) {
                            LOG.info((Object)"VM shutting down with the CacheManager still active. Calling shutdown.");
                        }
                        CacheManager.this.shutdown();
                    }
                }
            }
        };
        Runtime.getRuntime().addShutdownHook(localShutdownHook);
        this.shutdownHook = localShutdownHook;
    }

    private void removeShutdownHook() {
        if (this.shutdownHook != null) {
            block3: {
                try {
                    Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
                }
                catch (IllegalStateException e) {
                    if (!LOG.isDebugEnabled()) break block3;
                    LOG.debug((Object)"IllegalStateException due to attempt to remove a shutdownhook while the VM is actually shutting down.", (Throwable)e);
                }
            }
            this.shutdownHook = null;
        }
    }

    public synchronized void addCache(String cacheName) throws IllegalStateException, ObjectExistsException, CacheException {
        this.checkStatus();
        if (cacheName == null || cacheName.length() == 0) {
            return;
        }
        if (this.caches.get(cacheName) != null) {
            throw new ObjectExistsException("Cache " + cacheName + " already exists");
        }
        Ehcache cache = null;
        try {
            cache = (Ehcache)this.defaultCache.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new CacheException("Failure adding cache. Initial cause was " + e.getMessage(), e);
        }
        if (cache != null) {
            cache.setName(cacheName);
        }
        this.addCache(cache);
    }

    public synchronized void addCache(Cache cache) throws IllegalStateException, ObjectExistsException, CacheException {
        this.addCache((Ehcache)cache);
    }

    public synchronized void addCache(Ehcache cache) throws IllegalStateException, ObjectExistsException, CacheException {
        this.checkStatus();
        this.addCacheNoCheck(cache);
    }

    private synchronized void addCacheNoCheck(Ehcache cache) throws IllegalStateException, ObjectExistsException, CacheException {
        if (this.caches.get(cache.getName()) != null) {
            throw new ObjectExistsException("Cache " + cache.getName() + " already exists");
        }
        cache.setCacheManager(this);
        cache.setDiskStorePath(this.diskStorePath);
        cache.initialise();
        try {
            cache.bootstrap();
        }
        catch (CacheException e) {
            LOG.warn((Object)("Cache " + cache.getName() + "requested bootstrap but a CacheException occured. " + e.getMessage()), (Throwable)e);
        }
        this.caches.put(cache.getName(), cache);
        if (this.status.equals(Status.STATUS_ALIVE)) {
            this.cacheManagerEventListenerRegistry.notifyCacheAdded(cache.getName());
        }
    }

    public synchronized boolean cacheExists(String cacheName) throws IllegalStateException {
        this.checkStatus();
        return this.caches.get(cacheName) != null;
    }

    public synchronized void removalAll() {
        String[] cacheNames = this.getCacheNames();
        for (int i = 0; i < cacheNames.length; ++i) {
            String cacheName = cacheNames[i];
            this.removeCache(cacheName);
        }
    }

    public synchronized void removeCache(String cacheName) throws IllegalStateException {
        this.checkStatus();
        if (cacheName == null || cacheName.length() == 0) {
            return;
        }
        Ehcache cache = (Ehcache)this.caches.remove(cacheName);
        if (cache != null && cache.getStatus().equals(Status.STATUS_ALIVE)) {
            cache.dispose();
            this.cacheManagerEventListenerRegistry.notifyCacheRemoved(cache.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Class clazz = CacheManager.class;
        synchronized (clazz) {
            if (this.status.equals(Status.STATUS_SHUTDOWN)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"CacheManager already shutdown");
                }
                return;
            }
            if (this.cacheManagerPeerProvider != null) {
                this.cacheManagerPeerProvider.dispose();
            }
            this.cacheManagerEventListenerRegistry.dispose();
            Class clazz2 = CacheManager.class;
            synchronized (clazz2) {
                ALL_CACHE_MANAGERS.remove(this);
                Collection cacheSet = this.caches.values();
                Iterator iterator = cacheSet.iterator();
                while (iterator.hasNext()) {
                    Ehcache cache = (Ehcache)iterator.next();
                    if (cache == null) continue;
                    cache.dispose();
                }
                this.status = Status.STATUS_SHUTDOWN;
                if (this == singleton) {
                    singleton = null;
                }
                this.removeShutdownHook();
            }
        }
    }

    public synchronized String[] getCacheNames() throws IllegalStateException {
        this.checkStatus();
        String[] list = new String[this.caches.size()];
        return this.caches.keySet().toArray(list);
    }

    private void checkStatus() {
        if (!this.status.equals(Status.STATUS_ALIVE)) {
            throw new IllegalStateException("The CacheManager is not alive.");
        }
    }

    public Status getStatus() {
        return this.status;
    }

    public void clearAll() throws CacheException {
        String[] cacheNames = this.getCacheNames();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Clearing all caches");
        }
        for (int i = 0; i < cacheNames.length; ++i) {
            String cacheName = cacheNames[i];
            Ehcache cache = this.getEhcache(cacheName);
            cache.removeAll();
        }
    }

    public CacheManagerPeerProvider getCachePeerProvider() {
        return this.cacheManagerPeerProvider;
    }

    public CacheManagerPeerListener getCachePeerListener() {
        return this.cacheManagerPeerListener;
    }

    public CacheManagerEventListener getCacheManagerEventListener() {
        return this.cacheManagerEventListenerRegistry;
    }

    public void setCacheManagerEventListener(CacheManagerEventListener cacheManagerEventListener) {
        this.getCacheManagerEventListenerRegistry().registerListener(cacheManagerEventListener);
    }

    public CacheManagerEventListenerRegistry getCacheManagerEventListenerRegistry() {
        return this.cacheManagerEventListenerRegistry;
    }

    public CacheManagerPeerProvider getCacheManagerPeerProvider() {
        return this.cacheManagerPeerProvider;
    }

    public synchronized void replaceCacheWithDecoratedCache(Ehcache cache, Ehcache decoratedCache) throws CacheException {
        if (!cache.equals(decoratedCache)) {
            throw new CacheException("Cannot replace " + decoratedCache.getName() + " It does not equal the incumbent cache.");
        }
        this.caches.remove(cache.getName());
        this.caches.put(cache.getName(), decoratedCache);
    }

    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        return super.toString();
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        return this.getName();
    }
}

