/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.commons.util;

import java.io.File;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.t2framework.commons.util.Assertion;
import org.t2framework.commons.util.StringUtil;

public class Traversal {
    protected Traversal() {
    }

    public static void traverse(File rootDir, String rootPackage, ClassHandler handler) {
        Assertion.notNull(rootDir);
        Assertion.notNull(handler);
        Traversal.traverseFromFileSystem(rootDir, rootPackage, handler);
    }

    public static void traverseFromFileSystem(File rootDir, String rootPackage, ClassHandler handler) {
        Assertion.notNull(rootDir);
        Assertion.notNull(handler);
        File packageDir = Traversal.getPackageDir(rootDir, rootPackage);
        if (packageDir.exists()) {
            Traversal.traverseFileSystem(packageDir, rootPackage, handler);
        }
    }

    public static void traverseFromJarFile(JarFile jarFile, ClassHandler handler) {
        Assertion.notNull(jarFile);
        Assertion.notNull(handler);
        Traversal.doTraverseJar(jarFile, null, handler);
    }

    protected static void doTraverseJar(JarFile jarFile, String notUse, ClassHandler handler) {
        boolean hasWarExtension = jarFile.getName().endsWith(".war");
        Enumeration<JarEntry> e = jarFile.entries();
        while (e.hasMoreElements()) {
            JarEntry entry = e.nextElement();
            String entryName = entry.getName().replace('\\', '/');
            if (!entryName.endsWith(".class")) continue;
            int startPos = hasWarExtension && entryName.startsWith("WEB-INF/classes/") ? "WEB-INF/classes/".length() : 0;
            String className = entryName.substring(startPos, entryName.length() - ".class".length()).replace('/', '.');
            int pos = className.lastIndexOf(46);
            String packageName = pos == -1 ? null : className.substring(0, pos);
            String shortClassName = pos == -1 ? className : className.substring(pos + 1);
            handler.processClass(packageName, shortClassName);
        }
    }

    private static void traverseFileSystem(File packageDir, String packageName, ClassHandler handler) {
        File[] files = packageDir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            String filename = file.getName();
            if (file.isDirectory()) {
                String concatName = Traversal.concatName(packageName, filename);
                Traversal.traverseFileSystem(file, concatName, handler);
                continue;
            }
            if (!filename.endsWith(".class")) continue;
            String shortClassName = filename.substring(0, filename.lastIndexOf(".class"));
            handler.processClass(packageName, shortClassName);
        }
    }

    private static File getPackageDir(File rootDir, String rootPackage) {
        File packageDir = rootDir;
        if (rootPackage != null) {
            String[] names = rootPackage.split("\\.");
            for (int i = 0; i < names.length; ++i) {
                packageDir = new File(packageDir, names[i]);
            }
        }
        return packageDir;
    }

    private static String concatName(String s1, String s2) {
        if (StringUtil.isEmpty(s1)) {
            return s2;
        }
        return s1 + '.' + s2;
    }

    public static interface ClassHandler {
        public void processClass(String var1, String var2);
    }
}

