/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.commons.util;

import java.lang.reflect.Field;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.t2framework.commons.util.Logger;
import org.t2framework.commons.util.ResourceBundleUtil;

public class StringLoader {
    private static final Logger logger = Logger.getLogger(StringLoader.class);

    public static void load(Class<?> holder) {
        StringLoader.load(holder, holder.getName().replace('.', '/'));
    }

    public static void load(Class<?> holder, String name) {
        ResourceBundle rb = StringLoader.getBundle(name, holder.getClassLoader());
        if (rb == null) {
            return;
        }
        Field[] fields = holder.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            if (StringLoader.validateMask(field)) continue;
            String key = field.getName();
            if (!rb.containsKey(key)) {
                logger.debug(key + " not found in " + name);
                continue;
            }
            String msg = rb.getString(key);
            try {
                if (!StringLoader.isAssignableFrom(String.class, field)) continue;
                field.set(null, msg);
                continue;
            }
            catch (Exception e) {
                logger.debug(e.getMessage() + e);
            }
        }
    }

    private static boolean validateMask(Field f) {
        int MOD_EXPECTED = 9;
        int MOD_MASK = 25;
        return (f.getModifiers() & 0x19) != 9;
    }

    private static ResourceBundle getBundle(String name, ClassLoader loader) {
        try {
            return ResourceBundleUtil.getBundleNoCache(name, loader);
        }
        catch (MissingResourceException e) {
            return null;
        }
    }

    private static boolean isAssignableFrom(Class<?> clazz, Field target) {
        return clazz.isAssignableFrom(target.getType());
    }
}

