/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.commons.util;

import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;
import org.t2framework.commons.Constants;
import org.t2framework.commons.util.Assertion;
import org.t2framework.commons.util.MessageFormatter;
import org.t2framework.commons.util.StringUtil;

public class Logger {
    protected org.slf4j.Logger logger_;

    protected Logger(String name) {
        this.logger_ = LoggerFactory.getLogger((String)name);
    }

    protected Logger(Class<?> clazz) {
        this.logger_ = LoggerFactory.getLogger(clazz);
    }

    public static Logger getLogger(String name) {
        return new Logger(Assertion.notNull(name));
    }

    public static Logger getLogger(Class<?> clazz) {
        return new Logger(Assertion.notNull(clazz));
    }

    public Logger debug(String message) {
        if (this.isDebugEnabled()) {
            this.logger_.debug(message);
        }
        return this;
    }

    public Logger debug(String marker, String message) {
        if (this.isDebugEnabled()) {
            this.logger_.debug(this.getMarker(marker), message);
        }
        return this;
    }

    public Logger debug(String message, Object[] args) {
        if (this.isDebugEnabled()) {
            this.logger_.debug(message, args);
        }
        return this;
    }

    public Logger debug(String marker, String message, Object[] args) {
        if (this.isDebugEnabled()) {
            this.logger_.debug(this.getMarker(marker), message, args);
        }
        return this;
    }

    public Logger info(String message) {
        if (this.isInfoEnabled()) {
            this.logger_.info(message);
        }
        return this;
    }

    public Logger info(String marker, String message) {
        if (this.isInfoEnabled()) {
            this.logger_.info(this.getMarker(marker), message);
        }
        return this;
    }

    public Logger info(String message, Object[] args) {
        if (this.isInfoEnabled()) {
            this.logger_.info(message, args);
        }
        return this;
    }

    public Logger info(String marker, String message, Object[] args) {
        if (this.isInfoEnabled()) {
            this.logger_.info(this.getMarker(marker), message, args);
        }
        return this;
    }

    public Logger error(String message) {
        if (this.isErrorEnabled()) {
            this.logger_.error(message);
        }
        return this;
    }

    public Logger error(String marker, String message) {
        if (this.isErrorEnabled()) {
            this.logger_.error(this.getMarker(marker), message);
        }
        return this;
    }

    public Logger error(String message, Object[] args) {
        if (this.isErrorEnabled()) {
            this.logger_.error(message, args);
        }
        return this;
    }

    public Logger error(String marker, String message, Object[] args) {
        if (this.isErrorEnabled()) {
            this.logger_.error(this.getMarker(marker), message, args);
        }
        return this;
    }

    public Logger warn(String message) {
        if (this.isWarnEnabled()) {
            this.logger_.warn(message);
        }
        return this;
    }

    public Logger warn(String marker, String message) {
        if (this.isWarnEnabled()) {
            this.logger_.warn(this.getMarker(marker), message);
        }
        return this;
    }

    public Logger warn(String message, Object[] args) {
        if (this.isWarnEnabled()) {
            this.logger_.warn(message, args);
        }
        return this;
    }

    public Logger warn(String marker, String message, Object[] args) {
        if (this.isWarnEnabled()) {
            this.logger_.warn(this.getMarker(marker), message, args);
        }
        return this;
    }

    public Logger trace(String message) {
        if (this.logger_.isTraceEnabled()) {
            this.logger_.trace(message);
        }
        return this;
    }

    public Logger trace(String marker, String message) {
        if (this.logger_.isTraceEnabled()) {
            this.logger_.trace(this.getMarker(marker), message);
        }
        return this;
    }

    public Logger trace(String message, Object[] args) {
        if (this.isTraceEnabled()) {
            this.logger_.trace(message, args);
        }
        return this;
    }

    public Logger trace(String marker, String message, Object[] args) {
        if (this.isTraceEnabled()) {
            this.logger_.trace(this.getMarker(marker), message, args);
        }
        return this;
    }

    public boolean isDebugEnabled() {
        return this.logger_.isDebugEnabled();
    }

    public boolean isInfoEnabled() {
        return this.logger_.isInfoEnabled();
    }

    public boolean isErrorEnabled() {
        return this.logger_.isErrorEnabled();
    }

    public boolean isTraceEnabled() {
        return this.logger_.isTraceEnabled();
    }

    public boolean isWarnEnabled() {
        return this.logger_.isWarnEnabled();
    }

    public static void dispose() {
    }

    public void log(String messageCode) {
        this.log(null, messageCode);
    }

    public void log(String messageCode, Object[] args) {
        this.log(null, messageCode, null, args);
    }

    public void log(String marker, String messageCode) {
        this.log(marker, messageCode, Constants.EMPTY_ARRAY);
    }

    public void log(String marker, String messageCode, Object[] args) {
        this.log(marker, messageCode, null, args);
    }

    public void log(String messageCode, Throwable e) {
        this.log(messageCode, e, Constants.EMPTY_ARRAY);
    }

    public void log(String messageCode, Throwable e, Object[] args) {
        this.log(null, messageCode, e, args);
    }

    public void log(String marker, String messageCode, Throwable e, Object[] args) {
        Assertion.notNull(messageCode);
        if (messageCode.length() < 1) {
            throw new IllegalStateException("messageCode must not be empty string.");
        }
        char messageType = messageCode.charAt(0);
        String message = MessageFormatter.getSimpleMessage(messageCode, args);
        switch (messageType) {
            case 'D': {
                this.debug(marker, message);
                break;
            }
            case 'I': {
                this.info(marker, message);
                break;
            }
            case 'E': {
                this.error(marker, message);
                break;
            }
            case 'T': {
                this.trace(marker, message);
                break;
            }
            case 'W': {
                this.warn(marker, message);
                break;
            }
        }
    }

    protected Marker getMarker(String markerName) {
        if (StringUtil.isEmpty(markerName)) {
            return null;
        }
        return MarkerFactory.getMarker((String)markerName);
    }
}

