/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.commons.util;

import java.util.LinkedHashMap;
import java.util.Map;

public class LRUHashMap<K, V>
extends LinkedHashMap<K, V> {
    private static final long serialVersionUID = 4933303651654327647L;
    public static final int DEFAULT_LIMIT_SIZE = 32;
    public static final int DEFAULT_INITIAL_CAPACITY = 16;
    public static final float DEFAULT_LOAD_FACTOR = 0.75f;
    protected int limitSize;

    public LRUHashMap() {
        this(32, 16, 0.75f);
    }

    public LRUHashMap(int limitSize) {
        this(limitSize, 16, 0.75f);
    }

    public LRUHashMap(int limitSize, int initialCapacity) {
        this(limitSize, initialCapacity, 0.75f);
    }

    public LRUHashMap(int limitSize, int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor, true);
        this.limitSize = limitSize;
    }

    public int getLimitSize() {
        return this.limitSize;
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<K, V> entry) {
        return this.size() > this.limitSize;
    }
}

