/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.commons.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import org.t2framework.commons.Constants;
import org.t2framework.commons.exception.ParseRuntimeException;
import org.t2framework.commons.util.Base64Util;
import org.t2framework.commons.util.CollectionsUtil;
import org.t2framework.commons.util.DecimalFormatUtil;
import org.t2framework.commons.util.Logger;
import org.t2framework.commons.util.PatternUtil;
import org.t2framework.commons.util.StringUtil;

public class ConverterUtil {
    private static Logger logger = Logger.getLogger(ConverterUtil.class);
    public static final String NULL_PATTERN = null;
    public static final Pattern YES_PATTERN = PatternUtil.getPattern("(yes|true|y|1)", 2);
    private static Map<Class<?>, Converter<?>> map = CollectionsUtil.newHashMap();
    private static boolean initialized = false;
    public static Converter<BigDecimal> BIGDECIMAL_CONVERTER = new Converter<BigDecimal>(){

        @Override
        public BigDecimal convert(Object o, String pattern) {
            if (o == null) {
                return null;
            }
            if (BigDecimal.class.isInstance(o)) {
                return (BigDecimal)o;
            }
            if (o instanceof java.util.Date) {
                if (pattern != null) {
                    return new BigDecimal(new SimpleDateFormat(pattern).format(o));
                }
                return new BigDecimal(((java.util.Date)o).getTime());
            }
            if (Integer.class.isInstance(o)) {
                int i = (Integer)Integer.class.cast(o);
                return new BigDecimal(i);
            }
            if (Double.class.isInstance(o)) {
                double d = (Double)Double.class.cast(o);
                return new BigDecimal(d);
            }
            if (Long.class.isInstance(o)) {
                long l = (Long)Long.class.cast(o);
                return new BigDecimal(l);
            }
            if (Float.class.isInstance(o)) {
                float f = ((Float)Float.class.cast(o)).floatValue();
                return new BigDecimal(f);
            }
            if (Byte.class.isInstance(o)) {
                byte b = (Byte)Byte.class.cast(o);
                return new BigDecimal(b);
            }
            if (BigInteger.class.isInstance(o)) {
                BigInteger bi = (BigInteger)BigInteger.class.cast(o);
                return new BigDecimal(bi);
            }
            if (String.class.isInstance(o)) {
                String s = DecimalFormatUtil.normalize((String)o);
                if (StringUtil.isEmpty(s)) {
                    return null;
                }
                return new BigDecimal(s);
            }
            return null;
        }

        @Override
        public BigDecimal convert(Object o) {
            return this.convert(o, NULL_PATTERN);
        }
    };
    public static Converter<BigInteger> BIGINTEGER_CONVERTER = new Converter<BigInteger>(){

        @Override
        public BigInteger convert(Object o, String pattern) {
            if (o == null) {
                return null;
            }
            if (o instanceof BigInteger) {
                return (BigInteger)o;
            }
            if (o instanceof String) {
                String s = DecimalFormatUtil.normalize((String)String.class.cast(o));
                if (!StringUtil.isEmpty(s)) {
                    return new BigInteger(s);
                }
                return null;
            }
            return null;
        }

        @Override
        public BigInteger convert(Object o) {
            return this.convert(o, null);
        }
    };
    public static Converter<Byte> BYTE_CONVERTER = new Converter<Byte>(){

        @Override
        public Byte convert(Object o) {
            return this.convert(o, NULL_PATTERN);
        }

        protected Byte toByte(String s) {
            if (StringUtil.isEmpty(s)) {
                return null;
            }
            return Byte.valueOf(DecimalFormatUtil.normalize(s));
        }

        @Override
        public Byte convert(Object o, String pattern) {
            if (o == null) {
                return null;
            }
            if (o instanceof Byte) {
                return (Byte)o;
            }
            if (o instanceof Number) {
                return new Byte(((Number)o).byteValue());
            }
            if (o instanceof String) {
                return this.toByte((String)o);
            }
            if (o instanceof java.util.Date) {
                if (pattern != null) {
                    return new Byte(new SimpleDateFormat(pattern).format(o));
                }
                return new Byte((byte)((java.util.Date)o).getTime());
            }
            if (o instanceof Boolean) {
                return (Boolean)o != false ? new Byte(1) : new Byte(0);
            }
            return null;
        }
    };
    public static Converter<Byte> PRIMITIVE_BYTE_CONVERTER = new Converter<Byte>(){

        @Override
        public Byte convert(Object o) {
            return this.convert(o, NULL_PATTERN);
        }

        @Override
        public Byte convert(Object o, String pattern) {
            Byte convert = BYTE_CONVERTER.convert(o, pattern);
            if (convert == null) {
                return Constants.BYTE_DEFAULT_VALUE;
            }
            return convert;
        }
    };
    public static Converter<byte[]> BINARY_CONVERTER = new Converter<byte[]>(){

        @Override
        public byte[] convert(Object o) {
            if (o instanceof byte[]) {
                return (byte[])o;
            }
            if (o == null) {
                return null;
            }
            if (o instanceof String) {
                return Base64Util.decode((String)o);
            }
            return null;
        }

        @Override
        public byte[] convert(Object o, String pattern) {
            return this.convert(o);
        }
    };
    public static Converter<Boolean> BOOLEAN_CONVERTER = new Converter<Boolean>(){

        @Override
        public Boolean convert(Object value) {
            if (value == null) {
                return null;
            }
            if (Boolean.class.isInstance(value)) {
                return (Boolean)Boolean.class.cast(value);
            }
            if (String.class.isInstance(value)) {
                String s = (String)String.class.cast(value);
                return YES_PATTERN.matcher(s).matches();
            }
            if (Number.class.isInstance(value)) {
                Number n = (Number)Number.class.cast(value);
                return n.intValue() != 0;
            }
            return null;
        }

        @Override
        public Boolean convert(Object o, String pattern) {
            return this.convert(o);
        }
    };
    public static Converter<Boolean> PRIMITIVE_BOOLEAN_CONVERTER = new Converter<Boolean>(){

        @Override
        public Boolean convert(Object o) {
            Boolean convert = BOOLEAN_CONVERTER.convert(o);
            if (convert == null) {
                return Constants.BOOLEAN_DEFAULT_VALUE;
            }
            return convert;
        }

        @Override
        public Boolean convert(Object o, String pattern) {
            return this.convert(o);
        }
    };
    public static Converter<Calendar> CALENDAR_CONVERTER = new Converter<Calendar>(){

        @Override
        public Calendar convert(Object o, String pattern) {
            if (o instanceof Calendar) {
                return (Calendar)o;
            }
            java.util.Date date = (java.util.Date)DATE_CONVERTER.convert(o, pattern);
            if (date != null) {
                Calendar cal = Calendar.getInstance();
                cal.setTime(date);
                return cal;
            }
            return null;
        }

        @Override
        public Calendar convert(Object o) {
            return this.convert(o, NULL_PATTERN);
        }
    };
    public static DateConverter DATE_CONVERTER = new DateConverter(){

        @Override
        public java.util.Date convert(Object o, String pattern) {
            if (o == null) {
                return null;
            }
            if (o instanceof String) {
                return this.toDate((String)o, pattern);
            }
            if (o instanceof java.util.Date) {
                return (java.util.Date)o;
            }
            if (o instanceof Calendar) {
                return ((Calendar)o).getTime();
            }
            if (o instanceof Number) {
                return new java.util.Date(((Number)o).longValue());
            }
            return null;
        }

        @Override
        public java.util.Date convert(Object o) {
            return this.convert(o, NULL_PATTERN);
        }
    };
    public static Converter<Double> DOUBLE_CONVERTER = new Converter<Double>(){

        @Override
        public Double convert(Object o) {
            return this.convert(o, NULL_PATTERN);
        }

        @Override
        public Double convert(Object o, String pattern) {
            if (o == null) {
                return null;
            }
            if (o instanceof Double) {
                return (Double)o;
            }
            if (o instanceof Number) {
                return ((Number)o).doubleValue();
            }
            if (o instanceof String) {
                String s = DecimalFormatUtil.normalize((String)o);
                if (StringUtil.isEmpty(s)) {
                    return null;
                }
                return Double.valueOf(s);
            }
            return null;
        }
    };
    public static Converter<Double> PRIMITIVE_DOUBLE_CONVERTER = new Converter<Double>(){

        @Override
        public Double convert(Object o, String pattern) {
            Double convert = DOUBLE_CONVERTER.convert(o, pattern);
            if (convert == null) {
                return Constants.DOUBLE_DEFAULT_VALUE;
            }
            return convert;
        }

        @Override
        public Double convert(Object o) {
            return this.convert(o, NULL_PATTERN);
        }
    };
    public static Converter<Float> FLOAT_CONVERTER = new Converter<Float>(){

        @Override
        public Float convert(Object o, String pattern) {
            if (o == null) {
                return null;
            }
            if (o instanceof Float) {
                return (Float)o;
            }
            if (o instanceof Number) {
                return Float.valueOf(((Number)o).floatValue());
            }
            if (o instanceof String) {
                String s = DecimalFormatUtil.normalize((String)o);
                if (StringUtil.isEmpty(s)) {
                    return null;
                }
                return Float.valueOf(s);
            }
            return null;
        }

        @Override
        public Float convert(Object o) {
            return this.convert(o, NULL_PATTERN);
        }
    };
    public static Converter<Float> PRIMITIVE_FLOAT_CONVERTER = new Converter<Float>(){

        @Override
        public Float convert(Object o, String pattern) {
            Float convert = FLOAT_CONVERTER.convert(o, pattern);
            if (convert == null) {
                return Constants.FLOAT_DEFAULT_VALUE;
            }
            return convert;
        }

        @Override
        public Float convert(Object o) {
            return this.convert(o, NULL_PATTERN);
        }
    };
    public static Converter<Integer> INTEGER_CONVERTER = new Converter<Integer>(){

        @Override
        public Integer convert(Object o, String pattern) {
            if (o == null) {
                return null;
            }
            if (o instanceof Integer) {
                return (Integer)o;
            }
            if (o instanceof Number) {
                return ((Number)o).intValue();
            }
            if (o instanceof String) {
                String s = DecimalFormatUtil.normalize((String)o);
                if (StringUtil.isEmpty(s)) {
                    return null;
                }
                return Integer.valueOf(s);
            }
            if (o instanceof Boolean) {
                return (Boolean)o != false ? 1 : 0;
            }
            return null;
        }

        @Override
        public Integer convert(Object o) {
            return this.convert(o, NULL_PATTERN);
        }
    };
    public static Converter<Integer> PRIMITIVE_INTEGER_CONVERTER = new Converter<Integer>(){

        @Override
        public Integer convert(Object o, String pattern) {
            Integer convert = INTEGER_CONVERTER.convert(o, pattern);
            if (convert == null) {
                return Constants.INT_DEFAULT_VALUE;
            }
            return convert;
        }

        @Override
        public Integer convert(Object o) {
            return this.convert(o, NULL_PATTERN);
        }
    };
    public static Converter<Long> LONG_CONVERTER = new Converter<Long>(){

        @Override
        public Long convert(Object o, String pattern) {
            if (o == null) {
                return null;
            }
            if (o instanceof Long) {
                return (Long)o;
            }
            if (o instanceof Number) {
                return ((Number)o).longValue();
            }
            if (o instanceof String) {
                String s = DecimalFormatUtil.normalize((String)o);
                if (StringUtil.isEmpty(s)) {
                    return null;
                }
                return Long.valueOf(s);
            }
            if (o instanceof java.util.Date) {
                return ((java.util.Date)o).getTime();
            }
            if (o instanceof Boolean) {
                return (Boolean)o != false ? 1L : 0L;
            }
            return null;
        }

        @Override
        public Long convert(Object o) {
            return this.convert(o, NULL_PATTERN);
        }
    };
    public static Converter<Long> PRIMITIVE_LONG_CONVERTER = new Converter<Long>(){

        @Override
        public Long convert(Object o, String pattern) {
            Long convert = LONG_CONVERTER.convert(o, pattern);
            if (convert == null) {
                return Constants.LONG_DEFAULT_VALUE;
            }
            return convert;
        }

        @Override
        public Long convert(Object o) {
            return this.convert(o, NULL_PATTERN);
        }
    };
    public static Converter<Short> SHORT_CONVERTER = new Converter<Short>(){

        @Override
        public Short convert(Object o, String pattern) {
            if (o == null) {
                return null;
            }
            if (o instanceof Short) {
                return (Short)o;
            }
            if (o instanceof Number) {
                return ((Number)o).shortValue();
            }
            if (o instanceof String) {
                String s = DecimalFormatUtil.normalize((String)o);
                if (StringUtil.isEmpty(s)) {
                    return null;
                }
                return Short.valueOf(s);
            }
            if (o instanceof Boolean) {
                return (Boolean)o != false ? (short)1 : 0;
            }
            return null;
        }

        @Override
        public Short convert(Object o) {
            return this.convert(o, NULL_PATTERN);
        }
    };
    public static Converter<Short> PRIMITIVE_SHORT_CONVERTER = new Converter<Short>(){

        @Override
        public Short convert(Object o, String pattern) {
            Short convert = SHORT_CONVERTER.convert(o, pattern);
            if (convert == null) {
                return Constants.SHORT_DEFAULT_VALUE;
            }
            return convert;
        }

        @Override
        public Short convert(Object o) {
            return this.convert(o, NULL_PATTERN);
        }
    };
    public static Converter<Date> SQLDATE_CONVERTER = new Converter<Date>(){

        @Override
        public Date convert(Object o, String pattern) {
            if (o instanceof Date) {
                return (Date)o;
            }
            java.util.Date date = (java.util.Date)DATE_CONVERTER.convert(o, pattern);
            if (date != null) {
                return new Date(date.getTime());
            }
            return null;
        }

        @Override
        public Date convert(Object o) {
            return this.convert(o, NULL_PATTERN);
        }
    };
    public static Converter<String> STRING_CONVERTER = new Converter<String>(){

        @Override
        public String convert(Object value, String pattern) {
            if (value == null) {
                return null;
            }
            if (value instanceof String) {
                return (String)value;
            }
            if (value instanceof java.util.Date) {
                return this.toString((java.util.Date)value, pattern);
            }
            if (value instanceof Number) {
                return this.toString((Number)value, pattern);
            }
            if (value instanceof byte[]) {
                return Base64Util.encode((byte[])value);
            }
            if (value instanceof URL) {
                return ((URL)value).toExternalForm();
            }
            if (value instanceof URI) {
                try {
                    return ((URI)value).toURL().toExternalForm();
                }
                catch (MalformedURLException e) {
                    logger.log("URI conversion error:" + e.getMessage());
                    return null;
                }
            }
            return null;
        }

        protected String toString(Number value, String pattern) {
            if (value != null) {
                if (pattern != null) {
                    return new DecimalFormat(pattern).format(value);
                }
                return value.toString();
            }
            return null;
        }

        protected String toString(java.util.Date value, String pattern) {
            if (value != null) {
                if (pattern != null) {
                    return new SimpleDateFormat(pattern).format(value);
                }
                return value.toString();
            }
            return null;
        }

        @Override
        public String convert(Object o) {
            return this.convert(o, NULL_PATTERN);
        }
    };
    public static Converter<Time> TIME_CONVERTER = new Converter<Time>(){

        @Override
        public Time convert(Object o) {
            return this.convert(o, NULL_PATTERN);
        }

        @Override
        public Time convert(Object o, String pattern) {
            if (o instanceof Time) {
                return (Time)o;
            }
            java.util.Date date = (java.util.Date)DATE_CONVERTER.convert(o, pattern);
            if (date != null) {
                return new Time(date.getTime());
            }
            return null;
        }
    };
    public static Converter<Timestamp> TIMESTAMP_CONVERTER = new Converter<Timestamp>(){

        @Override
        public Timestamp convert(Object o) {
            return this.convert(o, NULL_PATTERN);
        }

        @Override
        public Timestamp convert(Object o, String pattern) {
            if (o instanceof Timestamp) {
                return (Timestamp)o;
            }
            java.util.Date date = (java.util.Date)DATE_CONVERTER.convert(o, pattern);
            if (date != null) {
                return new Timestamp(date.getTime());
            }
            return null;
        }
    };
    public static Converter<URL> URL_CONVERTER = new Converter<URL>(){

        @Override
        public URL convert(Object o) {
            if (o instanceof URL) {
                return (URL)o;
            }
            try {
                String url = STRING_CONVERTER.convert(o);
                if (url != null) {
                    return new URL(url);
                }
                return null;
            }
            catch (MalformedURLException e) {
                logger.log("URL conversion error:" + e.getMessage(), e.getMessage());
                return null;
            }
        }

        @Override
        public URL convert(Object o, String pattern) {
            return this.convert(o);
        }
    };
    public static Converter<URI> URI_CONVERTER = new Converter<URI>(){

        @Override
        public URI convert(Object o) {
            try {
                if (o instanceof URI) {
                    return (URI)o;
                }
                if (o instanceof URL) {
                    return new URI(((URL)o).toExternalForm());
                }
                String url = STRING_CONVERTER.convert(o);
                if (url != null) {
                    return new URI(url);
                }
                return null;
            }
            catch (URISyntaxException e) {
                logger.log("URI conversion error:" + e.getMessage(), e.getMessage());
                return null;
            }
        }

        @Override
        public URI convert(Object o, String pattern) {
            return this.convert(o);
        }
    };
    public static final Converter<InputStream> INPUTSTREAM_CONVERTER = new Converter<InputStream>(){

        @Override
        public InputStream convert(Object o) {
            if (o == null) {
                return null;
            }
            if (o instanceof InputStream) {
                return (InputStream)o;
            }
            try {
                if (o instanceof File) {
                    return new FileInputStream((File)o);
                }
                URL url = URL_CONVERTER.convert(o);
                if (url != null) {
                    return url.openStream();
                }
            }
            catch (IOException ex) {
                logger.log(ex.getMessage(), ex);
            }
            return null;
        }

        @Override
        public InputStream convert(Object o, String pattern) {
            return this.convert(o);
        }
    };
    public static final Converter<Reader> READER_CONVERTER = new Converter<Reader>(){

        @Override
        public Reader convert(Object o) {
            if (o == null) {
                return null;
            }
            if (o instanceof Reader) {
                return (Reader)o;
            }
            InputStream in = INPUTSTREAM_CONVERTER.convert(o);
            if (in != null) {
                return new InputStreamReader(in);
            }
            return null;
        }

        @Override
        public Reader convert(Object o, String pattern) {
            return this.convert(o);
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void init() {
        if (initialized) return;
        Class<ConverterUtil> clazz = ConverterUtil.class;
        synchronized (ConverterUtil.class) {
            ConverterUtil.init0();
            initialized = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static void init0() {
        map.put(BigDecimal.class, BIGDECIMAL_CONVERTER);
        map.put(BigInteger.class, BIGINTEGER_CONVERTER);
        map.put(Byte.class, BYTE_CONVERTER);
        map.put(Byte.TYPE, PRIMITIVE_BYTE_CONVERTER);
        map.put(byte[].class, BINARY_CONVERTER);
        map.put(Boolean.class, BOOLEAN_CONVERTER);
        map.put(Boolean.TYPE, PRIMITIVE_BOOLEAN_CONVERTER);
        map.put(Double.class, DOUBLE_CONVERTER);
        map.put(Double.TYPE, PRIMITIVE_DOUBLE_CONVERTER);
        map.put(Float.class, FLOAT_CONVERTER);
        map.put(Float.TYPE, PRIMITIVE_FLOAT_CONVERTER);
        map.put(Integer.class, INTEGER_CONVERTER);
        map.put(Integer.TYPE, PRIMITIVE_INTEGER_CONVERTER);
        map.put(Long.class, LONG_CONVERTER);
        map.put(Long.TYPE, PRIMITIVE_LONG_CONVERTER);
        map.put(Short.class, SHORT_CONVERTER);
        map.put(Short.TYPE, PRIMITIVE_SHORT_CONVERTER);
        map.put(String.class, STRING_CONVERTER);
        map.put(Calendar.class, CALENDAR_CONVERTER);
        map.put(java.util.Date.class, DATE_CONVERTER);
        map.put(Date.class, SQLDATE_CONVERTER);
        map.put(Time.class, TIME_CONVERTER);
        map.put(Timestamp.class, TIMESTAMP_CONVERTER);
        map.put(URL.class, URL_CONVERTER);
        map.put(URI.class, URI_CONVERTER);
        map.put(InputStream.class, INPUTSTREAM_CONVERTER);
        map.put(Reader.class, READER_CONVERTER);
    }

    public static synchronized void clear() {
        map.clear();
        initialized = false;
        ConverterUtil.init();
    }

    public static <T> T convert(Object target, Class<T> convertClass) {
        return ConverterUtil.convert(target, convertClass, NULL_PATTERN);
    }

    public static <T> T convert(Object target, Class<T> convertClass, String pattern) {
        ConverterUtil.init();
        Converter<?> converter = map.get(convertClass);
        if (converter == null) {
            if (convertClass.isInstance(target)) {
                return (T)target;
            }
            return null;
        }
        return (T)converter.convert(target, pattern);
    }

    public static String convertAsString(Object o) {
        return ConverterUtil.convertAsString(o, NULL_PATTERN);
    }

    public static String convertAsString(Object o, String pattern) {
        return STRING_CONVERTER.convert(o, pattern);
    }

    public static BigDecimal convertAsBigDecimal(Object o) {
        return ConverterUtil.convertAsBigDecimal(o, NULL_PATTERN);
    }

    public static BigDecimal convertAsBigDecimal(Object o, String pattern) {
        return BIGDECIMAL_CONVERTER.convert(o, pattern);
    }

    public static BigInteger convertAsBigInteger(Object o) {
        return ConverterUtil.convertAsBigInteger(o, NULL_PATTERN);
    }

    public static BigInteger convertAsBigInteger(Object o, String pattern) {
        return BIGINTEGER_CONVERTER.convert(o, pattern);
    }

    public static byte[] convertAsBinary(Object o) {
        return ConverterUtil.convertAsBinary(o, NULL_PATTERN);
    }

    public static byte[] convertAsBinary(Object o, String pattern) {
        return BINARY_CONVERTER.convert(o, pattern);
    }

    public static Boolean convertAsBoolean(Object o) {
        return ConverterUtil.convertAsBoolean(o, NULL_PATTERN);
    }

    public static Boolean convertAsBoolean(Object o, String pattern) {
        return BOOLEAN_CONVERTER.convert(o, pattern);
    }

    public static Boolean convertAsPrimitiveBoolean(Object o) {
        return ConverterUtil.convertAsPrimitiveBoolean(o, NULL_PATTERN);
    }

    public static Boolean convertAsPrimitiveBoolean(Object o, String pattern) {
        return PRIMITIVE_BOOLEAN_CONVERTER.convert(o, pattern);
    }

    public static Byte convertAsByte(Object o) {
        return ConverterUtil.convertAsByte(o, NULL_PATTERN);
    }

    public static Byte convertAsByte(Object o, String pattern) {
        return BYTE_CONVERTER.convert(o, pattern);
    }

    public static Byte convertAsPrimitiveByte(Object o) {
        return ConverterUtil.convertAsPrimitiveByte(o, NULL_PATTERN);
    }

    public static Byte convertAsPrimitiveByte(Object o, String pattern) {
        return PRIMITIVE_BYTE_CONVERTER.convert(o, pattern);
    }

    public static Double convertAsDouble(Object o) {
        return ConverterUtil.convertAsDouble(o, NULL_PATTERN);
    }

    public static Double convertAsDouble(Object o, String pattern) {
        return DOUBLE_CONVERTER.convert(o, pattern);
    }

    public static Double convertAsPrimitiveDouble(Object o) {
        return ConverterUtil.convertAsPrimitiveDouble(o, NULL_PATTERN);
    }

    public static Double convertAsPrimitiveDouble(Object o, String pattern) {
        return PRIMITIVE_DOUBLE_CONVERTER.convert(o, pattern);
    }

    public static Float convertAsFloat(Object o) {
        return ConverterUtil.convertAsFloat(o, NULL_PATTERN);
    }

    public static Float convertAsFloat(Object o, String pattern) {
        return FLOAT_CONVERTER.convert(o, pattern);
    }

    public static Float convertAsPrimitiveFloat(Object o) {
        return ConverterUtil.convertAsPrimitiveFloat(o, NULL_PATTERN);
    }

    public static Float convertAsPrimitiveFloat(Object o, String pattern) {
        return PRIMITIVE_FLOAT_CONVERTER.convert(o, pattern);
    }

    public static Integer convertAsInteger(Object o) {
        return ConverterUtil.convertAsInteger(o, NULL_PATTERN);
    }

    public static Integer convertAsInteger(Object o, String pattern) {
        return INTEGER_CONVERTER.convert(o, pattern);
    }

    public static Integer convertAsPrimitiveInteger(Object o) {
        return ConverterUtil.convertAsPrimitiveInteger(o, NULL_PATTERN);
    }

    public static Integer convertAsPrimitiveInteger(Object o, String pattern) {
        return PRIMITIVE_INTEGER_CONVERTER.convert(o, pattern);
    }

    public static Long convertAsLong(Object o) {
        return ConverterUtil.convertAsLong(o, NULL_PATTERN);
    }

    public static Long convertAsLong(Object o, String pattern) {
        return LONG_CONVERTER.convert(o, pattern);
    }

    public static Long convertAsPrimitiveLong(Object o) {
        return ConverterUtil.convertAsPrimitiveLong(o, NULL_PATTERN);
    }

    public static Long convertAsPrimitiveLong(Object o, String pattern) {
        return PRIMITIVE_LONG_CONVERTER.convert(o, pattern);
    }

    public static Short convertAsShort(Object o) {
        return ConverterUtil.convertAsShort(o, NULL_PATTERN);
    }

    public static Short convertAsShort(Object o, String pattern) {
        return SHORT_CONVERTER.convert(o, pattern);
    }

    public static Short convertAsPrimitiveShort(Object o) {
        return ConverterUtil.convertAsPrimitiveShort(o, NULL_PATTERN);
    }

    public static Short convertAsPrimitiveShort(Object o, String pattern) {
        return PRIMITIVE_SHORT_CONVERTER.convert(o, pattern);
    }

    public static Date convertAsSqlDate(Object o) {
        return ConverterUtil.convertAsSqlDate(o, NULL_PATTERN);
    }

    public static Date convertAsSqlDate(Object o, String pattern) {
        return SQLDATE_CONVERTER.convert(o, pattern);
    }

    public static Timestamp convertAsTimestamp(Object o) {
        return ConverterUtil.convertAsTimestamp(o, NULL_PATTERN);
    }

    public static Timestamp convertAsTimestamp(Object o, String pattern) {
        return TIMESTAMP_CONVERTER.convert(o, pattern);
    }

    public static Time convertAsTime(Object o) {
        return ConverterUtil.convertAsTime(o, NULL_PATTERN);
    }

    public static Time convertAsTime(Object o, String pattern) {
        return TIME_CONVERTER.convert(o, pattern);
    }

    public static Calendar convertAsCalendar(Object o) {
        return ConverterUtil.convertAsCalendar(o, NULL_PATTERN);
    }

    public static Calendar convertAsCalendar(Object o, String pattern) {
        return CALENDAR_CONVERTER.convert(o, pattern);
    }

    public static java.util.Date convertAsDate(Object o) {
        return ConverterUtil.convertAsDate(o, NULL_PATTERN);
    }

    public static java.util.Date convertAsDate(Object o, String pattern) {
        return (java.util.Date)DATE_CONVERTER.convert(o, pattern);
    }

    public static URL convertAsURL(Object o) {
        return URL_CONVERTER.convert(o, NULL_PATTERN);
    }

    public static URI convertAsURI(Object o) {
        return URI_CONVERTER.convert(o, NULL_PATTERN);
    }

    public static abstract class DateConverter
    implements Converter<java.util.Date> {
        public java.util.Date toDate(String s, String pattern) {
            return this.toDate(s, pattern, Locale.getDefault());
        }

        public java.util.Date toDate(String s, String pattern, Locale locale) {
            SimpleDateFormat sdf = this.getDateFormat(s, pattern, locale);
            try {
                return sdf.parse(s);
            }
            catch (ParseException ex) {
                throw new ParseRuntimeException(ex);
            }
        }

        public SimpleDateFormat getDateFormat(String s, String pattern, Locale locale) {
            if (pattern != null) {
                return this.createSimpleDateFormat(pattern);
            }
            return this.getDateFormat(s, locale);
        }

        public SimpleDateFormat getDateFormat(String s, Locale locale) {
            String pattern = this.getPattern(locale);
            String shortPattern = this.removeDelimiter(pattern);
            String delimitor = this.findDelimiter(s);
            if (delimitor == null) {
                if (s.length() == shortPattern.length()) {
                    return this.createSimpleDateFormat(shortPattern);
                }
                if (s.length() == shortPattern.length() + 2) {
                    return this.createSimpleDateFormat(StringUtil.replace(shortPattern, "yy", "yyyy"));
                }
            } else {
                String[] array = StringUtil.split(s, delimitor);
                for (int i = 0; i < array.length; ++i) {
                    if (array[i].length() != 4) continue;
                    pattern = StringUtil.replace(pattern, "yy", "yyyy");
                    break;
                }
                return this.createSimpleDateFormat(pattern);
            }
            return this.createSimpleDateFormat();
        }

        public SimpleDateFormat getDateFormat(Locale locale) {
            return this.createSimpleDateFormat(this.getPattern(locale));
        }

        public SimpleDateFormat getY4DateFormat(Locale locale) {
            return this.createSimpleDateFormat(this.getY4Pattern(locale));
        }

        public String getY4Pattern(Locale locale) {
            String pattern = this.getPattern(locale);
            if (pattern.indexOf("yyyy") < 0) {
                pattern = StringUtil.replace(pattern, "yy", "yyyy");
            }
            return pattern;
        }

        public String getPattern(Locale locale) {
            SimpleDateFormat df = (SimpleDateFormat)DateFormat.getDateInstance(3, locale);
            String pattern = df.toPattern();
            int index = pattern.indexOf(32);
            if (index > 0) {
                pattern = pattern.substring(0, index);
            }
            if (pattern.indexOf("MM") < 0) {
                pattern = StringUtil.replace(pattern, "M", "MM");
            }
            if (pattern.indexOf("dd") < 0) {
                pattern = StringUtil.replace(pattern, "d", "dd");
            }
            return pattern;
        }

        public String findDelimiter(String value) {
            for (int i = 0; i < value.length(); ++i) {
                char c = value.charAt(i);
                if (Character.isDigit(c)) continue;
                return Character.toString(c);
            }
            return null;
        }

        public String removeDelimiter(String pattern) {
            StringBuilder builder = new StringBuilder(pattern.length());
            for (int i = 0; i < pattern.length(); ++i) {
                char c = pattern.charAt(i);
                if (c != 'y' && c != 'M' && c != 'd') continue;
                builder.append(c);
            }
            return builder.toString();
        }

        protected SimpleDateFormat createSimpleDateFormat(String pattern) {
            return new SimpleDateFormat(pattern);
        }

        protected SimpleDateFormat createSimpleDateFormat() {
            return new SimpleDateFormat();
        }
    }

    public static interface Converter<T> {
        public T convert(Object var1);

        public T convert(Object var1, String var2);
    }
}

