/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.commons.util;

import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.t2framework.commons.util.CaseInsensitiveMap;

public class CaseInsensitiveSet<E>
extends AbstractSet<E>
implements Set<E>,
Serializable {
    private static final long serialVersionUID = 0L;
    private transient Map<E, Object> map;
    private static final Object PRESENT = new Object();

    public CaseInsensitiveSet() {
        this.map = CaseInsensitiveMap.newCaseInsensitiveMap();
    }

    public CaseInsensitiveSet(Collection<E> c) {
        int capacity = Math.max((int)((float)c.size() / 0.75f) + 1, 16);
        this.map = CaseInsensitiveMap.newCaseInsensitiveMap(capacity);
        this.addAll(c);
    }

    public CaseInsensitiveSet(int initialCapacity) {
        this.map = CaseInsensitiveMap.newCaseInsensitiveMap(initialCapacity);
    }

    @Override
    public Iterator<E> iterator() {
        return this.map.keySet().iterator();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    @Override
    public boolean add(E o) {
        return this.map.put(o, PRESENT) == null;
    }

    @Override
    public boolean remove(Object o) {
        return this.map.remove(o) == PRESENT;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    public static <E> CaseInsensitiveSet<E> set() {
        return new CaseInsensitiveSet<E>();
    }

    public static <E> CaseInsensitiveSet<E> set(Collection<E> c) {
        return new CaseInsensitiveSet<E>(c);
    }

    public static <E> CaseInsensitiveSet<E> set(int capacity) {
        return new CaseInsensitiveSet<E>(capacity);
    }
}

