/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.commons.util;

public class Assertion {
    public static <T> T notNull(T target) {
        return Assertion.notNull(target, null);
    }

    public static <T> T notNull(T target, String message) {
        if (target == null) {
            throw new NullPointerException(message);
        }
        return target;
    }

    public static <T> T[] notNulls(T ... args) {
        Assertion.notNull(args);
        for (int i = 0; i < args.length; ++i) {
            Assertion.notNull(args[i]);
        }
        return args;
    }

    public static <T> boolean isNotNull(T t) {
        return t != null;
    }

    public static <T> boolean hasNotNull(T ... args) {
        return !Assertion.hasNull(args);
    }

    public static <T> boolean isNull(T t) {
        return t == null;
    }

    public static <T> boolean hasNull(T ... args) {
        Assertion.notNull(args);
        for (T t : args) {
            if (t != null) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean isAllNull(T ... args) {
        Assertion.notNull(args);
        for (T t : args) {
            if (t == null) continue;
            return false;
        }
        return true;
    }

    public static void positive(int i) {
        if (i < 0) {
            throw new IllegalArgumentException();
        }
    }
}

