/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.commons.util;

import java.lang.reflect.Array;
import org.t2framework.commons.util.Assertion;

public class ArrayUtil {
    public static <T> boolean isEmpty(T[] array) {
        return array == null || array.length == 0;
    }

    public static <T> T[] add(T[] current, T value) {
        Assertion.notNull(current);
        Object[] newone = (Object[])Array.newInstance(current.getClass().getComponentType(), current.length + 1);
        ArrayUtil.copyAll(current, newone);
        newone[current.length] = value;
        return newone;
    }

    public static <T> T[] addFirst(T[] current, T value) {
        Assertion.notNull(current);
        Object[] newone = (Object[])Array.newInstance(current.getClass().getComponentType(), current.length + 1);
        ArrayUtil.copy(current, newone, 0, 1, current.length);
        newone[0] = value;
        return newone;
    }

    public static <T> T[] addAll(T[] from, T[] to) {
        Assertion.notNulls(from, to);
        Object[] newone = (Object[])Array.newInstance(from.getClass().getComponentType(), from.length + to.length);
        ArrayUtil.copyAll(from, newone);
        ArrayUtil.copy(to, newone, 0, from.length, to.length);
        return newone;
    }

    public static <T> T[] copyAll(T[] from, T[] to) {
        System.arraycopy(from, 0, to, 0, from.length);
        return to;
    }

    public static <T> T[] copy(T[] from, T[] to, int fromPos, int toPos, int length) {
        System.arraycopy(from, fromPos, to, toPos, length);
        return to;
    }

    public static <T> boolean contains(T[] array, T element) {
        if (array == null || element == null) {
            return false;
        }
        for (T t : array) {
            if (!element.equals(t)) continue;
            return true;
        }
        return false;
    }
}

