/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.commons.util;

import java.lang.annotation.Annotation;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;
import java.lang.reflect.AnnotatedElement;
import java.util.List;
import java.util.Set;
import org.t2framework.commons.Disposable;
import org.t2framework.commons.Disposer;
import org.t2framework.commons.meta.AnnotationConfig;
import org.t2framework.commons.meta.Config;
import org.t2framework.commons.meta.spi.AnnotationConfigCreator;
import org.t2framework.commons.module.Modules;
import org.t2framework.commons.util.Assertion;
import org.t2framework.commons.util.CollectionsUtil;

public class AnnotationUtil {
    protected static final Set<Class<? extends Annotation>> javaLangAnnotationSet = CollectionsUtil.newHashSet();
    protected static volatile AnnotationConfigCreator creator;

    private static void init() {
        javaLangAnnotationSet.add(Retention.class);
        javaLangAnnotationSet.add(Target.class);
        javaLangAnnotationSet.add(Documented.class);
        javaLangAnnotationSet.add(Inherited.class);
        javaLangAnnotationSet.add(Deprecated.class);
    }

    public static boolean isJavaLangAnnotation(Annotation a) {
        Assertion.notNull(a);
        return javaLangAnnotationSet.contains(a.annotationType());
    }

    public static List<Config> createAnnotationDescList(AnnotatedElement ae, ElementType elementType) {
        Assertion.notNulls(new Object[]{ae, elementType});
        List<Config> list = CollectionsUtil.newArrayList();
        for (Annotation a : ae.getDeclaredAnnotations()) {
            AnnotationConfig[] configs;
            if (AnnotationUtil.isJavaLangAnnotation(a)) continue;
            for (AnnotationConfig ad : configs = AnnotationUtil.createAnnotationConfigs(a)) {
                if (ad == null) continue;
                ad.setElementType(elementType);
                list.add(ad);
            }
        }
        return list;
    }

    public static boolean isTargetAnnotation(Annotation a) {
        Assertion.notNull(a);
        return a.annotationType().equals(Target.class);
    }

    public static Target getTargetAnnotation(Annotation a) {
        Assertion.notNull(a);
        return a.annotationType().getAnnotation(Target.class);
    }

    public static boolean hasAnnotationType(Class<? extends Annotation> target, Annotation[] annotations) {
        for (Annotation a : annotations) {
            if (target != a.annotationType()) continue;
            return true;
        }
        for (Annotation a : annotations) {
            boolean b;
            Annotation[] metas = a.annotationType().getAnnotations();
            if (metas == null || AnnotationUtil.isTopLevelAnnotations(metas) || !(b = AnnotationUtil.hasAnnotationType(target, metas))) continue;
            return true;
        }
        return false;
    }

    public static boolean isTopLevelAnnotations(Annotation[] annotations) {
        if (annotations == null) {
            return false;
        }
        for (Annotation a : annotations) {
            if (AnnotationUtil.isJavaLangAnnotation(a)) continue;
            return false;
        }
        return true;
    }

    public static AnnotationConfig[] createAnnotationConfigs(Annotation a) {
        AnnotationUtil.loadAnnotationConfigCreator();
        return creator.createAnnotationConfigs(a);
    }

    public static AnnotationConfig createAnnotationConfig(Annotation a) {
        AnnotationUtil.loadAnnotationConfigCreator();
        return creator.createAnnotationConfig(a);
    }

    protected static void loadAnnotationConfigCreator() {
        if (creator == null) {
            creator = Modules.getService(AnnotationConfigCreator.class);
        }
    }

    public static void dispose() {
        creator = null;
        javaLangAnnotationSet.clear();
        AnnotationUtil.init();
    }

    static {
        Disposer.add(new Disposable(){

            @Override
            public void dispose() {
                AnnotationUtil.dispose();
            }
        });
        AnnotationUtil.init();
    }
}

