/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.commons.ut;

import java.lang.reflect.Method;
import org.t2framework.commons.Constants;
import org.t2framework.commons.exception.NoSuchMethodRuntimeException;
import org.t2framework.commons.module.Modules;
import org.t2framework.commons.ut.BaseTestCase;
import org.t2framework.commons.ut.UtPlugin;
import org.t2framework.commons.util.Reflections;

public class DefaultUtPlugin
implements UtPlugin {
    protected BaseTestCase testCase;
    protected boolean verbose = false;

    public DefaultUtPlugin(BaseTestCase testCase) {
        this(testCase, false);
    }

    public DefaultUtPlugin(BaseTestCase testCase, boolean verbose) {
        this.testCase = testCase;
        this.verbose = verbose;
    }

    @Override
    public void begin() throws Throwable {
    }

    @Override
    public void setUp() throws Throwable {
        this.testCase.setUp();
    }

    @Override
    public void setUpEach() throws Throwable {
        this.setUpEach0();
    }

    @Override
    public void runTest() throws Throwable {
        this.testCase.runTest();
    }

    @Override
    public void handleRunTestThrowable(Throwable running) {
    }

    @Override
    public void handleTearDownThrowable(Throwable tearingDown) {
    }

    @Override
    public void tearDownEach() throws Throwable {
        this.tearDownEach0();
    }

    protected void setUpEach0() throws Throwable {
        String targetName = this.getTargetName();
        if (targetName.length() > 0) {
            this.invoke("setUp" + targetName);
        }
    }

    protected void tearDownEach0() throws Throwable {
        String targetName = this.getTargetName();
        if (targetName.length() > 0) {
            this.invoke("tearDown" + targetName);
        }
    }

    protected String getTargetName() {
        return this.testCase.getName().substring("test".length());
    }

    protected Object invoke(String methodName) throws Throwable {
        try {
            Method method = Reflections.MethodUtil.getDeclaredMethod(((Object)((Object)this.testCase)).getClass(), methodName, Constants.EMPTY_CLASS_ARRAY);
            return Reflections.MethodUtil.invoke(method, (Object)this.testCase, Constants.EMPTY_ARRAY);
        }
        catch (NoSuchMethodRuntimeException ignore) {
            return null;
        }
    }

    @Override
    public void tearDown() throws Throwable {
        this.testCase.tearDown();
    }

    @Override
    public void end() throws Throwable {
        Modules.dispose();
    }

    @Override
    public long beginMeasure() {
        return System.currentTimeMillis();
    }

    @Override
    public void endMeasure(long start) {
        long end = System.currentTimeMillis();
        String testname = this.testCase.getName();
        if (this.verbose) {
            System.out.println("[begin\t" + testname + "]" + start + "ms");
            System.out.println("[end\t" + testname + "]" + end + "ms");
        }
        System.out.println("[result\t" + testname + "]" + (end - start) + "ms");
    }
}

