/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.commons.ut;

import junit.framework.TestCase;
import org.t2framework.commons.ut.DefaultUtPlugin;
import org.t2framework.commons.ut.UtPlugin;

public abstract class BaseTestCase
extends TestCase {
    protected boolean measurable = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runBare() throws Throwable {
        UtPlugin plugin = this.getUtPlugin();
        this.measurable = this.isMeasurable();
        Throwable exception = null;
        try {
            plugin.begin();
            try {
                plugin.setUp();
                try {
                    plugin.setUpEach();
                    long start = 0L;
                    try {
                        if (this.measurable) {
                            start = plugin.beginMeasure();
                        }
                        try {
                            plugin.runTest();
                        }
                        catch (Throwable running) {
                            plugin.handleRunTestThrowable(running);
                            exception = running;
                        }
                    }
                    finally {
                        if (this.measurable) {
                            plugin.endMeasure(start);
                        }
                    }
                }
                finally {
                    plugin.tearDownEach();
                }
            }
            finally {
                block22: {
                    try {
                        plugin.tearDown();
                    }
                    catch (Throwable tearingDown) {
                        plugin.handleTearDownThrowable(tearingDown);
                        if (exception != null) break block22;
                        exception = tearingDown;
                    }
                }
            }
            if (exception != null) {
                throw exception;
            }
        }
        finally {
            plugin.end();
            this.setDefaultMeasurable();
        }
    }

    protected boolean isMeasurable() {
        return this.measurable;
    }

    protected void setDefaultMeasurable() {
        this.measurable = false;
    }

    protected void setMeasurable(boolean measurable) {
        this.measurable = measurable;
    }

    protected UtPlugin getUtPlugin() {
        return new DefaultUtPlugin(this);
    }

    public void setUp() throws Exception {
    }

    public void runTest() throws Throwable {
        super.runTest();
    }

    public void tearDown() throws Exception {
    }

    public void success() {
        BaseTestCase.assertTrue((boolean)true);
    }

    public void teeNotNull(Object o) {
        System.out.println(o);
        BaseTestCase.assertNotNull((Object)o);
    }
}

