/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.commons.module;

import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.t2framework.commons.Disposable;
import org.t2framework.commons.Disposer;
import org.t2framework.commons.bootstrap.CommonsInitializer;
import org.t2framework.commons.module.CommonModule;
import org.t2framework.commons.module.Module;
import org.t2framework.commons.util.CollectionsUtil;
import org.t2framework.commons.util.Reflections;

public class Modules {
    public static final CommonModule CORE_MODULE = CommonsInitializer.get(CommonModule.class);
    protected static ConcurrentHashMap<Class<? extends Module>, Module> modulesMap = new ConcurrentHashMap();
    protected static List<Properties> propsList = CollectionsUtil.newArrayList();
    protected static List<Object> servicesList = CollectionsUtil.newArrayList();
    protected static AtomicBoolean initialized = new AtomicBoolean(false);
    public static Finder<Object> objectFinder = new Finder<Object>(){

        @Override
        protected Object handle(Class<?> clazz, Object t) {
            if (t == null) {
                return null;
            }
            Class<?> target = t.getClass();
            if (clazz.isAssignableFrom(target)) {
                return t;
            }
            return null;
        }
    };
    public static Finder<Properties> propertiesFinder = new Finder<Properties>(){

        @Override
        protected Object handle(Class<?> clazz, Properties properties) {
            String name = clazz.getName();
            if (properties.containsKey(name)) {
                String classname = properties.getProperty(name);
                Class c = Reflections.ClassUtil.forNameNoException(classname);
                if (c == null) {
                    return null;
                }
                int mod = c.getModifiers();
                if (c.isPrimitive() || c.isAnnotation() || c.isEnum() || c.isInterface() || Modifier.isAbstract(mod)) {
                    throw new IllegalStateException();
                }
                return Reflections.ClassUtil.newInstance(c);
            }
            return null;
        }
    };
    public static Finder<Module> moduleFinder = new Finder<Module>(){

        @Override
        protected Object handle(Class clazz, Module module) {
            return module.getService(clazz);
        }
    };
    public static Finder<Module> commonsFinder = new Finder<Module>(){

        @Override
        protected Object handle(Class clazz, Module module) {
            return CommonsInitializer.get(clazz);
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void init() {
        if (!initialized.get()) {
            AtomicBoolean atomicBoolean = initialized;
            synchronized (atomicBoolean) {
                modulesMap.putIfAbsent(CommonModule.class, CORE_MODULE);
                Disposer.add(new Disposable(){

                    @Override
                    public void dispose() {
                        Modules.dispose();
                    }
                });
                initialized.compareAndSet(false, true);
            }
        }
    }

    public static <M extends Module> M getModule(Class<M> moduleClass) {
        Modules.init();
        for (Class m : modulesMap.keySet()) {
            if (!moduleClass.isAssignableFrom(m)) continue;
            return (M)modulesMap.get(m);
        }
        return null;
    }

    public static void addModule(Module ... modules) {
        if (modules == null || modules.length == 0) {
            return;
        }
        Modules.init();
        for (Module module : modules) {
            Class<?> c = null;
            for (c = module.getClass(); c != null && c.getSuperclass() != Module.class; c = c.getSuperclass()) {
                Modules.analyzeByInterface(c, module);
            }
        }
    }

    protected static void analyzeByInterface(Class<?> c, Module module) {
        Class<?>[] interfaces;
        if (c == Module.class) {
            return;
        }
        if (!modulesMap.containsKey(c)) {
            modulesMap.putIfAbsent(c, module);
        }
        for (Class<?> cl : interfaces = c.getInterfaces()) {
            Modules.analyzeByInterface(cl, module);
        }
    }

    public static void addProperties(Properties ... props) {
        if (props == null || props.length == 0) {
            return;
        }
        Modules.init();
        propsList.addAll(Arrays.asList(props));
    }

    public static void addServices(Object ... services) {
        if (services.length == 0) {
            return;
        }
        Modules.init();
        servicesList.addAll(Arrays.asList(services));
    }

    public static synchronized <S> S getService(Class<? super S> serviceClass) {
        Modules.init();
        Object result = objectFinder.find(serviceClass, servicesList);
        if (result != null) {
            return (S)result;
        }
        result = propertiesFinder.find(serviceClass, propsList);
        if (result != null) {
            return (S)result;
        }
        Collection<Module> iterable = modulesMap.values();
        result = moduleFinder.find(serviceClass, iterable);
        if (result != null) {
            return (S)result;
        }
        return (S)commonsFinder.find(serviceClass, iterable);
    }

    public static synchronized void dispose() {
        servicesList.clear();
        propsList.clear();
        modulesMap.clear();
        initialized.compareAndSet(true, false);
    }

    protected static abstract class Finder<T> {
        protected Finder() {
        }

        Object find(Class<?> clazz, Iterable<T> targetList) {
            for (T t : targetList) {
                Object ret = this.handle(clazz, t);
                if (ret == null) continue;
                return ret;
            }
            return null;
        }

        protected abstract Object handle(Class<?> var1, T var2);
    }
}

