/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.commons.meta.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.t2framework.commons.meta.AnnotationConfig;
import org.t2framework.commons.meta.MethodDesc;
import org.t2framework.commons.meta.ModifierDesc;
import org.t2framework.commons.meta.impl.AbstractConfigContainer;
import org.t2framework.commons.meta.impl.ModifierDescImpl;
import org.t2framework.commons.util.AnnotationUtil;
import org.t2framework.commons.util.Assertion;
import org.t2framework.commons.util.Reflections;

public class MethodDescImpl
extends AbstractConfigContainer
implements MethodDesc {
    protected Method method;
    protected String methodName;
    protected Class<?> returnType;
    protected Class<?>[] parameterTypes;
    protected Class<?>[] exceptionTypes;
    protected MethodParameter[] paramerters;
    protected AnnotationConfig[][] parameterAnnotationDesc;
    protected Annotation[][] parameterAnnotations;
    protected final ModifierDesc modifierDelegate;
    protected Class<?> declaringClass;

    public MethodDescImpl(Method method) {
        this.method = Assertion.notNull(method);
        this.methodName = method.getName();
        this.returnType = method.getReturnType();
        this.parameterTypes = method.getParameterTypes();
        this.modifierDelegate = new ModifierDescImpl(method.getModifiers());
        this.exceptionTypes = method.getExceptionTypes();
        this.declaringClass = method.getDeclaringClass();
        this.getConfigSupport().addAllAnnotationConfig(method);
        this.initParameters(method);
    }

    protected void initParameters(Method method) {
        this.parameterAnnotations = method.getParameterAnnotations();
        if (this.parameterAnnotations.length == 0) {
            return;
        }
        this.paramerters = new MethodParameter[this.parameterAnnotations.length];
        for (int i = 0; i < this.parameterAnnotations.length; ++i) {
            MethodParameter param;
            Annotation[] annotations = this.parameterAnnotations[i];
            this.paramerters[i] = param = new MethodParameter(i, this.parameterTypes[i], annotations);
        }
    }

    @Override
    public Method getMethod() {
        return this.method;
    }

    @Override
    public String getMethodName() {
        return this.methodName;
    }

    @Override
    public Class<?> getReturnType() {
        return this.returnType;
    }

    @Override
    public Class<?>[] getParameterTypes() {
        return this.parameterTypes;
    }

    @Override
    public <T> Object invoke(T t, Object[] args) {
        Method method = this.getMethod();
        return Reflections.MethodUtil.invoke(method, t, args);
    }

    @Override
    public Class<?>[] getExceptionTypes() {
        return this.exceptionTypes;
    }

    @Override
    public AnnotationConfig[][] getParameterAnnotationConfigs() {
        if (this.parameterAnnotationDesc == null) {
            this.parameterAnnotationDesc = new AnnotationConfig[this.parameterTypes.length][];
            for (int i = 0; i < this.parameterAnnotationDesc.length; ++i) {
                this.parameterAnnotationDesc[i] = this.getParameterAnnotationConfigs(i);
            }
        }
        return this.parameterAnnotationDesc;
    }

    @Override
    public AnnotationConfig[] getParameterAnnotationConfigs(int index) {
        return this.paramerters != null && this.paramerters.length > index ? this.paramerters[index].getAnnotationDescs() : new AnnotationConfig[]{};
    }

    @Override
    public int getParameterAnnotationConfigSize() {
        return this.paramerters.length;
    }

    @Override
    public Annotation[][] getParameterAnnotations() {
        return this.parameterAnnotations;
    }

    @Override
    public int getModifiers() {
        return this.modifierDelegate.getModifiers();
    }

    @Override
    public boolean isAbstract() {
        return this.modifierDelegate.isAbstract();
    }

    @Override
    public boolean isFinal() {
        return this.modifierDelegate.isFinal();
    }

    @Override
    public boolean isInterface() {
        return this.modifierDelegate.isInterface();
    }

    @Override
    public boolean isPublic() {
        return this.modifierDelegate.isPublic();
    }

    @Override
    public boolean isStatic() {
        return this.modifierDelegate.isStatic();
    }

    @Override
    public Class<?> getDeclaringClass() {
        return this.declaringClass;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.method == null ? 0 : this.method.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MethodDescImpl other = (MethodDescImpl)obj;
        return !(this.method == null ? other.method != null : !this.method.equals(other.method));
    }

    public static class MethodParameter {
        protected final int index;
        protected final Class<?> type;
        protected final Annotation[] annotations;
        protected AnnotationConfig[] annotationDescs;

        public MethodParameter(int index, Class<?> type, Annotation[] annotations) {
            this.index = index;
            this.type = type;
            this.annotations = annotations != null ? annotations : new Annotation[0];
        }

        public AnnotationConfig[] getAnnotationDescs() {
            if (this.annotationDescs == null) {
                this.annotationDescs = this.createAnnotationDescs(this.annotations);
            }
            return this.annotationDescs;
        }

        protected AnnotationConfig[] createAnnotationDescs(Annotation[] annotations) {
            AnnotationConfig[] desc = new AnnotationConfig[annotations.length];
            int i = 0;
            for (Annotation a : annotations) {
                desc[i++] = AnnotationUtil.createAnnotationConfig(a);
            }
            return desc;
        }

        public int getIndex() {
            return this.index;
        }

        public Class<?> getType() {
            return this.type;
        }

        public Annotation[] getAnnotations() {
            return this.annotations;
        }
    }
}

