/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.commons.meta.impl;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.t2framework.commons.Constants;
import org.t2framework.commons.meta.ClassDesc;
import org.t2framework.commons.meta.ConstructorDesc;
import org.t2framework.commons.meta.impl.AbstractConfigContainer;
import org.t2framework.commons.util.Assertion;
import org.t2framework.commons.util.Reflections;

public class ConstructorDescImpl<T>
extends AbstractConfigContainer
implements ConstructorDesc<T> {
    protected ClassDesc<T> classDesc = null;
    protected List<ConstructorInfo<T>> constructorInfoList = new ArrayList<ConstructorInfo<T>>();
    protected Constructor<?>[] constructors;
    protected Class<? extends T> targetClass;
    protected Class<? extends T> enhancedTargetClass;
    protected Constructor<T> defaultConstructor;

    public ConstructorDescImpl(ClassDesc<T> classDesc) {
        Assertion.notNull(classDesc);
        this.classDesc = classDesc;
        this.setup(classDesc);
    }

    public ConstructorDescImpl(Class<? extends T> targetClass) {
        this.targetClass = Assertion.notNull(targetClass);
        this.setup(targetClass);
    }

    protected void setup(ClassDesc<T> classDesc) {
        this.targetClass = classDesc.getComponentClass();
        this.setup(this.targetClass);
    }

    protected void setup(Class<? extends T> targetClass) {
        Constructor<?>[] constructors = targetClass.getConstructors();
        this.constructors = this.analyzeConstructors(constructors);
        this.getConfigSupport().addAllAnnotationConfig(constructors);
    }

    protected Constructor<?>[] analyzeConstructors(Constructor<?>[] constructors) {
        Assertion.notNull(constructors);
        for (Constructor<?> c : constructors) {
            Class<?>[] paramTypes = c.getParameterTypes();
            int paramLength = paramTypes.length;
            boolean[] primitives = new boolean[paramLength];
            boolean allNotPrimitives = true;
            this.analyzeDefaultConstructor(c, paramTypes, paramLength);
            for (int i = 0; i < primitives.length; ++i) {
                primitives[i] = paramTypes[i].isPrimitive();
                if (!primitives[i]) continue;
                allNotPrimitives = false;
            }
            ConstructorInfo info = new ConstructorInfo(c, paramTypes, paramLength, primitives, allNotPrimitives);
            this.constructorInfoList.add(info);
        }
        return constructors;
    }

    protected void analyzeDefaultConstructor(Constructor<?> c, Class<?>[] paramTypes, int paramLength) {
        boolean nested = this.targetClass.isMemberClass();
        boolean isDefault = false;
        if (paramLength == 0) {
            isDefault = true;
        } else if (nested && paramLength == 1) {
            boolean bl = isDefault = paramTypes[0] == this.targetClass.getEnclosingClass();
        }
        if (isDefault) {
            this.defaultConstructor = c;
        }
    }

    public final ClassDesc<T> getClassDesc() {
        return this.classDesc;
    }

    @Override
    public Constructor<T> getSuitableConstructor(Object ... args) {
        if (args == null) {
            args = Constants.EMPTY_ARRAY;
        }
        block0: for (int i = 0; i < this.constructorInfoList.size(); ++i) {
            ConstructorInfo<T> info = this.constructorInfoList.get(i);
            if (info.getParamLength() != args.length) continue;
            for (int j = 0; j < args.length; ++j) {
                Object o = args[j];
                if (o == null) continue;
                Class<?> argsClass = o.getClass();
                Class<?> paramType = info.getParamType(j);
                if (paramType.isPrimitive()) {
                    paramType = Reflections.ClassUtil.toWrapperClass(paramType);
                }
                if (!Reflections.ClassUtil.isAssignableFrom(argsClass, paramType)) continue block0;
            }
            return info.getConstructor();
        }
        return null;
    }

    @Override
    public Constructor<?>[] getConstructors() {
        return this.constructors;
    }

    @Override
    public Constructor<T> getConstructor(Class<?>[] paramTypes) {
        for (ConstructorInfo<T> info : this.constructorInfoList) {
            Object[] types = info.getParamTypes();
            if (!Arrays.equals(paramTypes, types)) continue;
            return info.getConstructor();
        }
        return null;
    }

    protected synchronized void setEnhancedComponentClass(Class<? extends T> componentClass) {
        this.enhancedTargetClass = componentClass;
        this.defaultConstructor = null;
        this.getConfigSupport().clear();
        this.constructorInfoList.clear();
        this.setup(this.enhancedTargetClass);
    }

    @Override
    public boolean hasDefaultConstructor() {
        return this.defaultConstructor != null;
    }

    @Override
    public boolean hasOnlyDefaultConstructor() {
        return this.hasDefaultConstructor() && this.constructorInfoList.size() == 1 && ((ConstructorInfo)this.constructorInfoList.get(0)).constructor == this.defaultConstructor;
    }

    @Override
    public Constructor<T> getDefaultConstructor() {
        return this.defaultConstructor;
    }

    @Override
    public Class<?> getDeclaringClass() {
        return this.enhancedTargetClass != null ? this.enhancedTargetClass : this.targetClass;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.constructors);
        result = 31 * result + (this.defaultConstructor == null ? 0 : this.defaultConstructor.hashCode());
        result = 31 * result + (this.targetClass == null ? 0 : this.targetClass.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConstructorDescImpl other = (ConstructorDescImpl)obj;
        if (!Arrays.equals(this.constructors, other.constructors)) {
            return false;
        }
        if (this.defaultConstructor == null ? other.defaultConstructor != null : !this.defaultConstructor.equals(other.defaultConstructor)) {
            return false;
        }
        return !(this.targetClass == null ? other.targetClass != null : !this.targetClass.equals(other.targetClass));
    }

    private static class ConstructorInfo<T> {
        private final Constructor<T> constructor;
        private final Class<?>[] paramTypes;
        private final int paramLength;
        private final boolean[] primitives;

        public ConstructorInfo(Constructor<T> constructor, Class<?>[] paramTypes, int paramLength, boolean[] primitives, boolean allNotPrimitives) {
            this.constructor = constructor;
            this.paramTypes = paramTypes;
            this.paramLength = paramLength;
            this.primitives = primitives;
        }

        public Constructor<T> getConstructor() {
            return this.constructor;
        }

        public int getParamLength() {
            return this.paramLength;
        }

        public Class<?>[] getParamTypes() {
            return this.paramTypes;
        }

        public boolean[] getPrimitives() {
            return this.primitives;
        }

        public Class<?> getParamType(int index) {
            if (index > this.getParamLength()) {
                return null;
            }
            return this.paramTypes[index];
        }

        public boolean isPrimitive(int index) {
            if (index > this.getParamLength()) {
                return false;
            }
            return this.primitives[index];
        }
    }
}

