/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.commons.meta.impl;

import java.lang.annotation.ElementType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.t2framework.commons.meta.Config;
import org.t2framework.commons.meta.ConfigContainer;
import org.t2framework.commons.meta.ConfigType;
import org.t2framework.commons.util.AnnotationUtil;
import org.t2framework.commons.util.Assertion;
import org.t2framework.commons.util.CollectionsUtil;

public class ConfigSupport {
    protected final ConfigContainer container;
    private static final List<Config> EMPTY_LIST = Collections.emptyList();
    protected List<Config> configList = CollectionsUtil.newArrayList();
    protected Map<Class<?>, List<Config>> typeMap = CollectionsUtil.newHashMap();

    public ConfigSupport(ConfigContainer container) {
        this.container = container;
    }

    public void addAllAnnotationConfig(Class<?> targetClass) {
        this.addAllAnnotationConfig(AnnotationUtil.createAnnotationDescList(targetClass, ElementType.TYPE));
    }

    public void addAllAnnotationConfig(Constructor<?>[] constructors) {
        List<Config> list = CollectionsUtil.newArrayList();
        for (Constructor<?> c : constructors) {
            list.addAll(AnnotationUtil.createAnnotationDescList(c, ElementType.CONSTRUCTOR));
        }
        this.addAllAnnotationConfig(list);
    }

    public void addAllAnnotationConfig(Method method) {
        this.addAllAnnotationConfig(AnnotationUtil.createAnnotationDescList(method, ElementType.METHOD));
    }

    public void addAllAnnotationConfig(Package package_) {
        if (package_ != null) {
            this.addAllAnnotationConfig(AnnotationUtil.createAnnotationDescList(package_, ElementType.PACKAGE));
        }
    }

    public void addAllAnnotationConfig(Field field) {
        this.addAllAnnotationConfig(AnnotationUtil.createAnnotationDescList(field, ElementType.FIELD));
    }

    protected void addAllAnnotationConfig(List<Config> list) {
        for (Config config : list) {
            this.addConfig(config);
        }
    }

    public void addConfig(Config config) {
        Assertion.notNull(config, "Config");
        Class<?> type = config.getType();
        if (type == null) {
            throw new IllegalStateException("config.getType()");
        }
        this.configList.add(config);
        List<Config> list = this.typeMap.get(type);
        if (list == null) {
            list = CollectionsUtil.newArrayList();
        }
        list.add(config);
        this.typeMap.put(type, list);
    }

    protected boolean isAnnotationType(Config config) {
        return config.getConfigType() == ConfigType.ANNOTATION;
    }

    protected boolean isOuterConfigType(Config config) {
        return config.getConfigType() == ConfigType.OUTER;
    }

    public Iterable<Config> findConfigs(Class<?> clazz) {
        return this.typeMap.containsKey(clazz) ? this.typeMap.get(clazz) : EMPTY_LIST;
    }

    public boolean hasConfig(Class<?> clazz) {
        return this.typeMap.containsKey(clazz);
    }

    public List<Config> getConfigs() {
        return this.configList;
    }

    public Config findConfig(Class<?> clazz) {
        Iterator<Config> i = this.findConfigs(clazz).iterator();
        return i.hasNext() ? i.next() : null;
    }

    public ConfigContainer getConfigContainer() {
        return this.container;
    }

    public void clear() {
        this.configList.clear();
        this.typeMap.clear();
    }
}

