/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.commons.meta.impl;

import java.io.Externalizable;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import org.t2framework.commons.meta.ClassDesc;
import org.t2framework.commons.meta.ModifierDesc;
import org.t2framework.commons.meta.impl.AbstractConfigContainer;
import org.t2framework.commons.meta.impl.ModifierDescImpl;
import org.t2framework.commons.util.Assertion;
import org.t2framework.commons.util.CollectionsUtil;

public class ClassDescImpl<T>
extends AbstractConfigContainer
implements ClassDesc<T> {
    protected String componentName;
    protected Class<? extends T> targetClass;
    protected Class<? extends T> enhancedTargetClass;
    protected List<Class<?>> dependencyClassesList = CollectionsUtil.newArrayList();
    protected final ModifierDesc modifierDelegate;
    private static Set<Class<?>> unacceptableClasses = CollectionsUtil.newHashSet();

    public ClassDescImpl(Class<? extends T> targetClass) {
        this(null, targetClass);
    }

    public ClassDescImpl(String componentName, Class<? extends T> targetClass) {
        this.targetClass = targetClass;
        this.modifierDelegate = new ModifierDescImpl(targetClass.getModifiers());
        this.setup(componentName);
    }

    protected void setup(String componentName) {
        this.analyzeClassDependency(this.targetClass);
        if (componentName != null) {
            this.componentName = componentName;
        }
        this.getConfigSupport().addAllAnnotationConfig(this.targetClass);
    }

    protected void analyzeClassDependency(Class<? extends T> targetClass) {
        for (Class<T> c = targetClass; c != null && c != Object.class; c = c.getSuperclass()) {
            this.analyzeByInterface(c);
        }
    }

    protected void analyzeByInterface(Class<?> c) {
        Class<?>[] interfaces;
        if (this.isUnacceptableClass(c)) {
            return;
        }
        this.addDependencyClass(c);
        for (Class<?> cl : interfaces = c.getInterfaces()) {
            this.analyzeByInterface(cl);
        }
    }

    protected void addDependencyClass(Class<?> clazz) {
        this.dependencyClassesList.add(clazz);
    }

    @Override
    public Class<? extends T> getComponentClass() {
        return this.targetClass;
    }

    @Override
    public List<Class<?>> getDependencyClassesList() {
        return this.dependencyClassesList;
    }

    @Override
    public boolean isUnacceptableClass(Class<?> c) {
        return unacceptableClasses.contains(c);
    }

    public static void addUnacceptableClass(Class<?> c) {
        unacceptableClasses.add(Assertion.notNull(c));
    }

    public static void clearUnacceptableClass() {
        ClassDescImpl.init();
    }

    @Override
    public String getComponentName() {
        return this.componentName;
    }

    private static void init() {
        Assertion.notNull(unacceptableClasses).clear();
        unacceptableClasses.add(Cloneable.class);
        unacceptableClasses.add(Comparable.class);
        unacceptableClasses.add(Serializable.class);
        unacceptableClasses.add(Externalizable.class);
    }

    @Override
    public Class<? extends T> getEnhancedComponentClass() {
        return this.enhancedTargetClass;
    }

    protected void setEnhancedComponentClass(Class<? extends T> componentClass) {
        this.enhancedTargetClass = componentClass;
    }

    @Override
    public Class<? extends T> getConcreteClass() {
        return this.enhancedTargetClass != null ? this.enhancedTargetClass : this.targetClass;
    }

    @Override
    public int getModifiers() {
        return this.modifierDelegate.getModifiers();
    }

    @Override
    public boolean isAbstract() {
        return this.modifierDelegate.isAbstract();
    }

    @Override
    public boolean isFinal() {
        return this.modifierDelegate.isFinal();
    }

    @Override
    public boolean isInterface() {
        return this.modifierDelegate.isInterface();
    }

    @Override
    public boolean isPublic() {
        return this.modifierDelegate.isPublic();
    }

    @Override
    public boolean isStatic() {
        return this.modifierDelegate.isStatic();
    }

    static {
        ClassDescImpl.init();
    }
}

