/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.commons.meta;

import java.lang.annotation.Annotation;
import java.util.Map;
import org.t2framework.commons.util.Assertion;
import org.t2framework.commons.util.CollectionsUtil;

public class LookupContext {
    protected final Class<? extends Annotation> targetAnnotationClass;
    protected Map<String, Object> methodValueMap = CollectionsUtil.newHashMap();

    public LookupContext(Class<? extends Annotation> targetAnnotationClass) {
        this.targetAnnotationClass = Assertion.notNull(targetAnnotationClass);
    }

    public void addMethodValue(String methodName, Object value) {
        Assertion.notNull(methodName);
        Assertion.notNull(value);
        this.methodValueMap.put(methodName, value);
    }

    public Class<? extends Annotation> getTargetAnnotationClass() {
        return this.targetAnnotationClass;
    }

    public Object getValue(String methodName) {
        return this.methodValueMap.get(Assertion.notNull(methodName));
    }

    public boolean contains(String methodName) {
        return this.methodValueMap.containsKey(Assertion.notNull(methodName));
    }
}

