/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.commons.cache.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import org.t2framework.commons.cache.CacheSynchronization;
import org.t2framework.commons.cache.CacheType;
import org.t2framework.commons.cache.impl.AbstractCache;
import org.t2framework.commons.util.Assertion;
import org.t2framework.commons.util.Logger;

public class FutureTaskCache<K, V>
extends AbstractCache<K, V> {
    protected static Logger logger = Logger.getLogger(FutureTaskCache.class);
    protected ConcurrentMap<K, Future<V>> cache;
    protected Map<K, V> map = new HashMap();

    protected FutureTaskCache(CacheSynchronization sync, int initialCapacity) {
        super(sync, initialCapacity);
    }

    @Override
    protected void createCache(CacheSynchronization sync, int initialCapacity) {
        this.cache = new ConcurrentHashMap<K, Future<V>>(initialCapacity);
    }

    @Override
    protected Map<K, V> getCache() {
        return this.map;
    }

    @Override
    protected V get0(final K key) {
        Assertion.notNull(key);
        while (true) {
            FutureTask task;
            FutureTask future;
            if ((future = (FutureTask)this.cache.get(key)) == null && (future = (Future)this.cache.putIfAbsent(key, task = new FutureTask(new Callable<V>(){

                @Override
                public V call() throws Exception {
                    return FutureTaskCache.this.map.get(key);
                }
            }))) == null) {
                future = task;
                task.run();
            }
            try {
                return future.get();
            }
            catch (InterruptedException e) {
                this.cache.remove(key, future);
                continue;
            }
            catch (ExecutionException e) {
                logger.debug(e.getMessage());
                continue;
            }
            break;
        }
    }

    @Override
    protected void clear0() {
        super.clear0();
        this.map.clear();
    }

    @Override
    public void put(K key, V value) {
        this.map.put(key, value);
    }

    @Override
    public void putIfAbsent(K key, V value) {
        this.map.put(key, value);
    }

    @Override
    public CacheType getCacheType() {
        return CacheType.FUTURE;
    }
}

