/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.commons.cache.impl;

import java.util.List;
import java.util.Map;
import org.t2framework.commons.Disposable;
import org.t2framework.commons.Disposer;
import org.t2framework.commons.cache.Cache;
import org.t2framework.commons.cache.CacheListener;
import org.t2framework.commons.cache.CacheSynchronization;
import org.t2framework.commons.util.Assertion;
import org.t2framework.commons.util.CollectionsUtil;

public abstract class AbstractCache<K, V>
implements Cache<K, V> {
    protected final CacheSynchronization sync;
    protected List<CacheListener<K, V>> listeners = CollectionsUtil.newArrayList();

    protected AbstractCache(CacheSynchronization sync, int initialCapacity) {
        this.sync = Assertion.notNull(sync);
        Disposer.add(new Disposable(){

            @Override
            public void dispose() {
                AbstractCache.this.clearAll();
            }
        });
        this.createCache(sync, initialCapacity);
    }

    protected abstract void createCache(CacheSynchronization var1, int var2);

    @Override
    public void addCacheListener(CacheListener<K, V> listener) {
        this.listeners.add(Assertion.notNull(listener));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        try {
            for (CacheListener<K, V> listener : this.listeners) {
                listener.beforeClear();
            }
            this.clear0();
        }
        finally {
            for (CacheListener<K, V> listener : this.listeners) {
                listener.afterClear();
            }
        }
    }

    protected void clear0() {
        this.getCache().clear();
    }

    protected void clearListener() {
        this.listeners.clear();
    }

    protected void clearAll() {
        this.clear0();
        this.clearListener();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(K key) {
        Assertion.notNull(key);
        Object value = null;
        try {
            for (CacheListener<K, V> listener : this.listeners) {
                listener.beforeGet(key);
            }
            Object v = value = (Object)this.get0(key);
            return v;
        }
        finally {
            for (CacheListener<K, Object> cacheListener : this.listeners) {
                cacheListener.afterGet(key, value);
            }
        }
    }

    protected V get0(K key) {
        return this.getCache().get(key);
    }

    @Override
    public CacheSynchronization getCacheSynchronization() {
        return this.sync;
    }

    @Override
    public int getSize() {
        return this.getCache().size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(K key, V value) {
        Assertion.notNull(key);
        try {
            for (CacheListener<K, V> listener : this.listeners) {
                listener.beforePut(key, value, this.getCache().size());
            }
            this.getCache().put(key, value);
        }
        finally {
            for (CacheListener<K, V> listener : this.listeners) {
                listener.afterPut(key, value, this.getCache().size());
            }
        }
    }

    @Override
    public void putIfAbsent(K key, V value) {
        Assertion.notNull(key);
        V old = this.get0(key);
        if (old == null) {
            this.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(K key) {
        Assertion.notNull(key);
        Object removedValue = null;
        try {
            for (CacheListener<K, V> listener : this.listeners) {
                listener.beforeRemove(key);
            }
            Object v = removedValue = (Object)this.getCache().remove(key);
            return v;
        }
        finally {
            for (CacheListener<K, Object> cacheListener : this.listeners) {
                cacheListener.afterRemove(key, removedValue);
            }
        }
    }

    @Override
    public boolean containsKey(K key) {
        Assertion.notNull(key);
        return this.getCache().containsKey(key);
    }

    protected abstract Map<K, V> getCache();
}

