/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.commons;

import java.util.LinkedList;
import org.t2framework.commons.Disposable;
import org.t2framework.commons.util.Assertion;
import org.t2framework.commons.util.Logger;

public class Disposer {
    public static final String DISPOSE_CATEGORY = "org.t2framework.commons.dispose";
    protected static final LinkedList<Disposable> disposables = new LinkedList();

    public static void add(Disposable disposable) {
        disposables.add(Assertion.notNull(disposable));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void dispose() {
        Logger logger = Logger.getLogger(DISPOSE_CATEGORY);
        try {
            int i = 0;
            while (!disposables.isEmpty()) {
                Disposable disposable = disposables.removeLast();
                try {
                    logger.debug("org.t2framework.commons.lifecycle", "Process disposable({}):{}", new Object[]{i, disposable});
                    disposable.dispose();
                }
                catch (Throwable t) {
                    logger.debug("org.t2framework.commons.lifecycle", "Exception occurs at disposable({}):{}", new Object[]{i, t.getMessage()});
                    t.printStackTrace();
                }
                finally {
                    disposable = null;
                }
                ++i;
            }
        }
        finally {
            logger = null;
            Logger.dispose();
            disposables.clear();
        }
    }
}

