/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.net;

import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.pattern.SyslogStartConverter;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.classic.spi.ThrowableDataPoint;
import ch.qos.logback.classic.util.LevelToSyslogSeverity;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.net.SyslogAppenderBase;
import ch.qos.logback.core.net.SyslogWriter;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyslogAppender
extends SyslogAppenderBase<LoggingEvent> {
    public static final String DEFAULT_SUFFIX_PATTERN = "[%thread] %logger %msg";
    PatternLayout prefixLayout = new PatternLayout();

    public Layout<LoggingEvent> buildLayout(String facilityStr) {
        String prefixPattern = "%syslogStart{" + facilityStr + "}%nopex";
        this.prefixLayout.getInstanceConverterMap().put("syslogStart", SyslogStartConverter.class.getName());
        this.prefixLayout.setPattern(prefixPattern);
        this.prefixLayout.setContext(this.getContext());
        this.prefixLayout.start();
        PatternLayout fullLayout = new PatternLayout();
        fullLayout.getInstanceConverterMap().put("syslogStart", SyslogStartConverter.class.getName());
        if (this.suffixPattern == null) {
            this.suffixPattern = DEFAULT_SUFFIX_PATTERN;
        }
        fullLayout.setPattern(prefixPattern + this.suffixPattern);
        fullLayout.setContext(this.getContext());
        fullLayout.start();
        return fullLayout;
    }

    public int getSeverityForEvent(Object eventObject) {
        LoggingEvent event = (LoggingEvent)eventObject;
        return LevelToSyslogSeverity.convert(event);
    }

    protected void postProcess(Object eventObject, SyslogWriter sw) {
        LoggingEvent event = (LoggingEvent)eventObject;
        String prefix = this.prefixLayout.doLayout(event);
        if (event.getThrowableProxy() != null) {
            ThrowableDataPoint[] strRep = event.getThrowableProxy().getThrowableDataPointArray();
            try {
                for (ThrowableDataPoint line : strRep) {
                    sw.write(prefix + line.toString());
                    sw.flush();
                }
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }
}

