/*
 * Decompiled with CFR 0.152.
 */
package org.doomdark.uuid;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import org.doomdark.uuid.EthernetAddress;

public class NativeInterfaces {
    protected static final String sDefaultLibSubdir = "jug-native";
    private static File sLibDir = null;
    private static boolean sUseStdLibDir = false;
    private static boolean mNativeLoaded = false;

    public static synchronized void setLibDir(File file) {
        sLibDir = file;
    }

    public static synchronized void setUseStdLibDir(boolean bl) {
        sUseStdLibDir = bl;
    }

    protected static synchronized void checkLoad() {
        if (!mNativeLoaded) {
            String string = System.getProperty("os.name").trim().toLowerCase();
            String string2 = System.getProperty("os.arch").trim().toLowerCase();
            String string3 = null;
            String string4 = null;
            if (string.indexOf("windows") >= 0) {
                string3 = "Win";
            } else if (string.indexOf("linux") >= 0) {
                string3 = "Linux";
            } else if (string.indexOf("solaris") >= 0 || string.indexOf("sunos") >= 0) {
                string3 = "Solaris";
            } else if (string.indexOf("mac os x") >= 0) {
                string3 = "MacOSX";
            } else {
                throw new Error("No native ethernet access library for OS '" + string + "'.");
            }
            if (string2.indexOf("x86") >= 0 || string2.indexOf("sparc") >= 0 || string2.indexOf("ppc") >= 0) {
                string4 = string2;
            } else if (string2.indexOf("86") >= 0 || string2.indexOf("amd") >= 0) {
                string4 = "x86";
            } else {
                throw new Error("No native ethernet access library for hardware platform with value '" + string2 + "'.");
            }
            String string5 = string3 + "_" + string4 + "_" + "EtherAddr";
            if (sUseStdLibDir) {
                NativeInterfaces.loadStdLib(string5);
            } else {
                NativeInterfaces.loadAppLib(string5);
            }
            mNativeLoaded = true;
        }
    }

    private static void loadStdLib(String string) {
        try {
            System.loadLibrary(string);
        }
        catch (SecurityException securityException) {
            throw new Error("Trying to load library '" + string + "': error; " + securityException.toString());
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            throw new Error("Trying to load library '" + string + "': error; " + unsatisfiedLinkError.toString());
        }
    }

    private static void loadAppLib(String string) {
        String string2 = System.mapLibraryName(string);
        String string3 = "Tried to load library '" + string + "' (filename assumed to be '" + string2 + "')";
        try {
            File file;
            if (sLibDir == null) {
                file = new File(sDefaultLibSubdir);
                file = new File(file, string2);
            } else {
                file = new File(sLibDir, string2);
            }
            try {
                file = file.getCanonicalFile();
            }
            catch (IOException iOException) {
                throw new Error(string3 + ": checking existence of '" + file.getAbsolutePath() + "': " + iOException.toString());
            }
            System.load(file.getAbsolutePath());
        }
        catch (SecurityException securityException) {
            throw new Error(string3 + ": error; " + securityException.toString());
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            throw new Error(string3 + ": error; " + unsatisfiedLinkError.toString());
        }
    }

    public static EthernetAddress getPrimaryInterface() {
        NativeInterfaces.checkLoad();
        try {
            com.ccg.net.ethernet.EthernetAddress ethernetAddress = com.ccg.net.ethernet.EthernetAddress.getPrimaryAdapter();
            if (ethernetAddress != null) {
                return new EthernetAddress(ethernetAddress.getBytes());
            }
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            throw new Error(unsatisfiedLinkError.toString());
        }
        return null;
    }

    public static EthernetAddress[] getAllInterfaces() {
        EthernetAddress[] ethernetAddressArray = null;
        NativeInterfaces.checkLoad();
        try {
            Collection collection = com.ccg.net.ethernet.EthernetAddress.getAllAdapters();
            ethernetAddressArray = new EthernetAddress[collection.size()];
            Iterator iterator = collection.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                com.ccg.net.ethernet.EthernetAddress ethernetAddress = (com.ccg.net.ethernet.EthernetAddress)iterator.next();
                ethernetAddressArray[n] = new EthernetAddress(ethernetAddress.getBytes());
                ++n;
            }
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            throw new Error(unsatisfiedLinkError.toString());
        }
        return ethernetAddressArray;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length > 0 && stringArray[0].equalsIgnoreCase("lib")) {
            System.out.println("Trying to access primary ethernet interface using system-dependant library loading (use 'app' argument for other test)");
            NativeInterfaces.setUseStdLibDir(true);
        } else {
            System.out.println("Trying to access primary ethernet interface using system independent code loading (use 'lib' argument for other test)");
            NativeInterfaces.setUseStdLibDir(false);
        }
        System.out.println("Trying to access primary ethernet interface:");
        try {
            EthernetAddress ethernetAddress = NativeInterfaces.getPrimaryInterface();
            System.out.println("Ok, the interface MAC-address is: " + ethernetAddress.toString());
        }
        catch (Throwable throwable) {
            System.out.println("Failed, error given: " + throwable.toString());
        }
    }
}

