/*
 * Decompiled with CFR 0.152.
 */
package org.openxri;

import org.openxri.GCSAuthority;
import org.openxri.IRIAuthority;
import org.openxri.Parsable;
import org.openxri.ParseStream;
import org.openxri.XRefAuthority;

public abstract class AuthorityPath
extends Parsable {
    AuthorityPath() {
    }

    AuthorityPath(String sPath) {
        super(sPath);
    }

    public static AuthorityPath buildAuthorityPath(String sPath) {
        ParseStream oStream = new ParseStream(sPath);
        AuthorityPath oPath = AuthorityPath.scanAuthority(oStream);
        return oStream.getData().length() == 0 ? oPath : null;
    }

    static AuthorityPath scanAuthority(ParseStream oParseStream) {
        GCSAuthority oGCSAuthority = new GCSAuthority();
        if (oGCSAuthority.scan(oParseStream)) {
            return oGCSAuthority;
        }
        XRefAuthority oXRefAuthority = new XRefAuthority();
        if (oXRefAuthority.scan(oParseStream)) {
            return oXRefAuthority;
        }
        IRIAuthority oIRIAuthority = new IRIAuthority();
        if (oIRIAuthority.scan(oParseStream)) {
            return oIRIAuthority;
        }
        return null;
    }

    public abstract String toIRINormalForm();

    public abstract String toURINormalForm();
}

