/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.t2.tag;

import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.t2framework.commons.util.DateUtil;
import org.t2framework.commons.util.HtmlEscapeUtil;
import org.t2framework.commons.util.URLUtil;
import org.t2framework.t2.contexts.Request;
import org.t2framework.t2.contexts.Response;
import org.t2framework.t2.contexts.WebContext;

public class Functions {
    protected static Map<String, ResourceBundle> messageResourceMap = new HashMap<String, ResourceBundle>();

    public static String out(Object o) {
        return o != null ? Functions.escape(o) : "";
    }

    public static String dateFormat(Date date) {
        if (date == null) {
            return null;
        }
        String pattern = DateUtil.findPattern((Locale)WebContext.get().getRequestLocale());
        return Functions.dateFormatWith(date, pattern);
    }

    public static String dateFormatWith(Date date, String pattern) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat formatter = new SimpleDateFormat(pattern);
        return formatter.format(date);
    }

    public static String url(String orgurl) {
        if (URLUtil.isAbsoluteUrl((String)orgurl)) {
            return orgurl;
        }
        WebContext context = WebContext.get();
        if (context == null) {
            return orgurl;
        }
        HttpServletRequest request = (HttpServletRequest)((Request)context.getRequest()).getNativeResource();
        if (request == null) {
            return orgurl;
        }
        String url = "";
        String contextPath = request.getContextPath();
        url = orgurl.indexOf(contextPath) == 0 ? orgurl : (!contextPath.endsWith("/") && !orgurl.startsWith("/") ? contextPath + "/" + orgurl : contextPath + orgurl);
        if (request.isRequestedSessionIdFromCookie()) {
            return url;
        }
        return ((HttpServletResponse)((Response)context.getResponse()).getNativeResource()).encodeURL(url);
    }

    public static String escape(Object input) {
        if (input == null) {
            return "";
        }
        String s = "";
        s = input.getClass().isArray() ? Functions.convertFromArray(input) : input.toString();
        return Functions.escape(s);
    }

    public static String escape(String s) {
        return HtmlEscapeUtil.escape((String)s);
    }

    public static String nls(String key) {
        WebContext context = WebContext.get();
        return Functions.findMessage(context.getRequestLocale(), key, new Object[0]);
    }

    public static String nls(String key, Object param1) {
        WebContext context = WebContext.get();
        return Functions.findMessage(context.getRequestLocale(), key, param1);
    }

    public static String nls(String key, Object param1, Object param2) {
        WebContext context = WebContext.get();
        return Functions.findMessage(context.getRequestLocale(), key, param1, param2);
    }

    public static String nls(String key, Object param1, Object param2, Object param3) {
        WebContext context = WebContext.get();
        return Functions.findMessage(context.getRequestLocale(), key, param1, param2, param3);
    }

    public static String nls(String key, Object param1, Object param2, Object param3, Object param4) {
        WebContext context = WebContext.get();
        return Functions.findMessage(context.getRequestLocale(), key, param1, param2, param3, param4);
    }

    public static String nls(String key, Object param1, Object param2, Object param3, Object param4, Object param5) {
        WebContext context = WebContext.get();
        return Functions.findMessage(context.getRequestLocale(), key, param1, param2, param3, param4, param5);
    }

    public static void addMessageResource(ResourceBundle bundle) {
        messageResourceMap.put(bundle.getLocale().getLanguage(), bundle);
    }

    protected static String findMessage(Locale locale, String key, Object ... objects) {
        ResourceBundle rb = messageResourceMap.get(locale.getLanguage());
        if (rb == null && (rb = messageResourceMap.get(Locale.getDefault().getLanguage())) == null && (rb = messageResourceMap.get("")) == null) {
            return "";
        }
        if (!rb.containsKey(key)) {
            return "";
        }
        String s = rb.getString(key);
        if (objects != null && 0 < objects.length) {
            return MessageFormat.format(s, objects);
        }
        return s;
    }

    private static String convertFromArray(Object input) {
        Class<?> clazz = input.getClass().getComponentType();
        String s = "";
        s = clazz == String.class ? Arrays.toString((Object[])input) : (clazz == Boolean.TYPE ? Arrays.toString((boolean[])input) : (clazz == Integer.TYPE ? Arrays.toString((int[])input) : (clazz == Long.TYPE ? Arrays.toString((long[])input) : (clazz == Byte.TYPE ? Arrays.toString((byte[])input) : (clazz == Short.TYPE ? Arrays.toString((short[])input) : (clazz == Float.TYPE ? Arrays.toString((float[])input) : (clazz == Double.TYPE ? Arrays.toString((double[])input) : (clazz == Character.TYPE ? Arrays.toString((char[])input) : Arrays.toString((Object[])input)))))))));
        return s;
    }
}

