/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.t2.spi.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.util.Streams;
import org.t2framework.commons.exception.IORuntimeException;
import org.t2framework.commons.util.CollectionsUtil;
import org.t2framework.t2.contexts.Multipart;
import org.t2framework.t2.contexts.UploadFile;
import org.t2framework.t2.filter.MultiPartRequestFilter;
import org.t2framework.t2.spi.impl.AbstractMultipartRequestHandler;

public class StreamMultipartRequestHandlerImpl
extends AbstractMultipartRequestHandler {
    @Override
    public Map<String, String[]> handle(HttpServletRequest request) {
        Map paramMap = CollectionsUtil.newHashMap((Map)request.getParameterMap());
        String enc = request.getCharacterEncoding();
        ServletFileUpload upload = new ServletFileUpload();
        upload.setHeaderEncoding(enc);
        upload.setFileSizeMax((long)MultiPartRequestFilter.maxFileSize);
        upload.setSizeMax((long)MultiPartRequestFilter.maxSize);
        try {
            Multipart multiPart = this.createMultipart();
            FileItemIterator iterator = upload.getItemIterator(request);
            while (iterator.hasNext()) {
                FileItemStream itemStream = iterator.next();
                String fieldName = itemStream.getFieldName();
                if (itemStream.isFormField()) {
                    String value = Streams.asString((InputStream)itemStream.openStream(), (String)enc);
                    paramMap.put(fieldName, this.add((Object[])paramMap.get(fieldName), value, String.class));
                    continue;
                }
                UploadFile uploadFile = this.createUploadFile(itemStream);
                multiPart.addUploadFile(fieldName, uploadFile);
            }
            this.storeMultipart(request, multiPart);
        }
        catch (FileUploadException e) {
            this.logUploadError(e, request);
            paramMap = request.getParameterMap();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        return Collections.unmodifiableMap(paramMap);
    }
}

