/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.t2.spi.impl;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.t2framework.commons.util.Assertion;
import org.t2framework.commons.util.CollectionsUtil;
import org.t2framework.commons.util.StringUtil;
import org.t2framework.t2.contexts.Multipart;
import org.t2framework.t2.contexts.UploadFile;
import org.t2framework.t2.filter.MultiPartRequestFilter;
import org.t2framework.t2.spi.impl.AbstractMultipartRequestHandler;

public class MultipartRequestHandlerImpl
extends AbstractMultipartRequestHandler {
    @Override
    public Map<String, String[]> handle(HttpServletRequest request) {
        Assertion.notNull((Object)request);
        String encoding = request.getCharacterEncoding();
        Map<String, String[]> paramMap = Collections.emptyMap();
        DiskFileItemFactory factory = new DiskFileItemFactory();
        factory.setSizeThreshold(MultiPartRequestFilter.thresholdSize);
        if (!StringUtil.isEmpty((String)MultiPartRequestFilter.repositoryPath)) {
            factory.setRepository(new File(MultiPartRequestFilter.repositoryPath));
        }
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
        upload.setHeaderEncoding(encoding);
        upload.setFileSizeMax((long)MultiPartRequestFilter.maxFileSize);
        upload.setSizeMax((long)MultiPartRequestFilter.maxSize);
        try {
            List requestList = upload.parseRequest(request);
            paramMap = this.prepareParameters(request, requestList, encoding);
        }
        catch (FileUploadException e) {
            this.logUploadError(e, request);
            paramMap = request.getParameterMap();
        }
        return paramMap;
    }

    protected Map<String, String[]> prepareParameters(HttpServletRequest request, List<FileItem> fileItemList, String encoding) {
        Map paramMap = CollectionsUtil.newHashMap((Map)request.getParameterMap());
        Multipart multiPart = this.createMultipart();
        for (FileItem fileItem : fileItemList) {
            Object value;
            String fieldName = fileItem.getFieldName();
            if (fileItem.isFormField()) {
                try {
                    value = fileItem.getString(encoding);
                }
                catch (UnsupportedEncodingException ex) {
                    throw new RuntimeException();
                }
                paramMap.put(fieldName, this.add((Object[])paramMap.get(fieldName), value, String.class));
                continue;
            }
            value = this.createUploadFile(fileItem);
            multiPart.addUploadFile(fieldName, (UploadFile)value);
        }
        this.storeMultipart(request, multiPart);
        return Collections.unmodifiableMap(paramMap);
    }
}

