/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.t2.spi.impl;

import java.io.IOException;
import java.lang.reflect.Array;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.FileUploadException;
import org.t2framework.commons.exception.IORuntimeException;
import org.t2framework.commons.util.Logger;
import org.t2framework.t2.contexts.Multipart;
import org.t2framework.t2.contexts.Request;
import org.t2framework.t2.contexts.UploadFile;
import org.t2framework.t2.contexts.impl.MultipartImpl;
import org.t2framework.t2.contexts.impl.StreamUploadFileImpl;
import org.t2framework.t2.contexts.impl.UploadFileImpl;
import org.t2framework.t2.filter.MultiPartRequestFilter;
import org.t2framework.t2.spi.MultipartRequestHandler;

public abstract class AbstractMultipartRequestHandler
implements MultipartRequestHandler {
    private static final Logger log = Logger.getLogger(AbstractMultipartRequestHandler.class);

    protected void logUploadError(FileUploadException e, HttpServletRequest request) {
        if (e instanceof FileUploadBase.InvalidContentTypeException) {
            log.log("WTDT0007", new Object[]{e, request.getContentType()});
        } else if (e instanceof FileUploadBase.IOFileUploadException) {
            log.log("WTDT0008", (Throwable)e, new Object[]{e.getMessage()});
        } else if (e instanceof FileUploadBase.FileSizeLimitExceededException) {
            log.log("WTDT0009", (Throwable)e, new Object[]{MultiPartRequestFilter.maxSize});
        } else if (e instanceof FileUploadBase.SizeLimitExceededException) {
            log.log("WTDT0010", (Throwable)e, new Object[]{request.getContentLength(), MultiPartRequestFilter.maxSize});
        } else {
            log.log("WTDT0011", (Throwable)e, new Object[]{e.toString()});
        }
    }

    protected void storeMultipart(HttpServletRequest request, Multipart multiPart) {
        request.setAttribute(Request.MULTIPART_ATTRIBUTE_KEY, (Object)multiPart);
    }

    protected Multipart createMultipart() {
        return new MultipartImpl();
    }

    protected UploadFile createUploadFile(FileItemStream itemStream) {
        try {
            return new StreamUploadFileImpl(itemStream);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    protected UploadFile createUploadFile(FileItem fileItem) {
        return new UploadFileImpl(fileItem);
    }

    protected <T> T[] add(T[] objs, T value, Class<T> clazz) {
        Object[] newObjs;
        if (objs == null) {
            newObjs = (Object[])Array.newInstance(clazz, 1);
            newObjs[0] = value;
        } else {
            newObjs = (Object[])Array.newInstance(objs.getClass().getComponentType(), objs.length + 1);
            System.arraycopy(objs, 0, newObjs, 0, objs.length);
            newObjs[objs.length] = value;
        }
        return newObjs;
    }

    protected Object getFirst(Object obj) {
        Object[] objs = (Object[])obj;
        if (objs == null || objs.length == 0) {
            return null;
        }
        return objs[0];
    }
}

