/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.t2.navigation;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.t2framework.commons.util.ArrayUtil;
import org.t2framework.commons.util.CollectionsUtil;
import org.t2framework.commons.util.Logger;
import org.t2framework.commons.util.UrlBuilder;
import org.t2framework.t2.contexts.FrameworkComponent;
import org.t2framework.t2.contexts.Request;
import org.t2framework.t2.contexts.Response;
import org.t2framework.t2.contexts.WebContext;
import org.t2framework.t2.contexts.impl.RequestImpl;
import org.t2framework.t2.navigation.WebNavigation;
import org.t2framework.t2.util.PathUtil;

public class Proceed
extends WebNavigation {
    protected static Logger logger = Logger.getLogger(Proceed.class);
    protected Map<String, Object> paramMap = new HashMap<String, Object>();
    protected Map<String, String> attributeMap = new HashMap<String, String>();

    public static Proceed proceed(String path) {
        return new Proceed(path);
    }

    public Proceed(String path) {
        super(path);
        this.paramMap = new HashMap<String, Object>();
    }

    public void setParameterMap(Map<String, Object> paramMap) {
        this.paramMap = paramMap;
    }

    public void setAttributeMap(Map<String, String> attributeMap) {
        this.attributeMap = attributeMap;
    }

    public Proceed addAttribute(String key, String value) {
        this.attributeMap.put(key, value);
        return this;
    }

    public Proceed addParam(String key, String value) {
        if (this.paramMap.containsKey(key)) {
            Object old = this.paramMap.remove(key);
            if (old instanceof String) {
                this.paramMap.put(key, new String[]{(String)old, value});
            } else if (old instanceof String[]) {
                this.paramMap.put(key, ArrayUtil.add((Object[])((String[])old), (Object)value));
            }
        } else {
            this.paramMap.put(key, value);
        }
        return this;
    }

    @Override
    public void execute(WebContext context) throws Exception {
        if (!this.path.startsWith("/")) {
            logger.log("ITDT0020", new Object[]{"Forward"});
            this.path = PathUtil.appendStartSlashIfNeed(this.path);
        }
        HttpServletRequest request = (HttpServletRequest)((Request)context.getRequest()).getNativeResource();
        for (Object n : CollectionsUtil.newEnumerationIterable((Enumeration)request.getAttributeNames())) {
            String name = (String)n;
            request.removeAttribute(name);
        }
        for (Map.Entry<String, String> entry : this.attributeMap.entrySet()) {
            request.setAttribute(entry.getKey(), (Object)entry.getValue());
        }
        final Map<String, Object> map = this.paramMap;
        HttpServletRequestWrapper wrapper = new HttpServletRequestWrapper(request){

            public String getMethod() {
                return "GET";
            }

            public String getRequestURI() {
                String path = Proceed.this.getPath();
                String contextPath = this.getContextPath();
                return !"/".equals(contextPath) ? contextPath + path : path;
            }

            public String getParameter(String name) {
                String[] values = this.getParameterValues(name);
                return values != null ? values[0] : null;
            }

            public Map getParameterMap() {
                return map;
            }

            public Enumeration getParameterNames() {
                return CollectionsUtil.newIteratorEnumeration(map.keySet().iterator());
            }

            public String[] getParameterValues(String name) {
                Object object = map.get(name);
                if (object instanceof String) {
                    return new String[]{(String)object};
                }
                if (object instanceof String[]) {
                    return (String[])object;
                }
                return null;
            }
        };
        if (context instanceof FrameworkComponent) {
            ((FrameworkComponent)FrameworkComponent.class.cast(context)).setRequest(new RequestImpl((HttpServletRequest)wrapper, (HttpServletResponse)((Response)context.getResponse()).getNativeResource()));
        }
        String realpath = this.buildForwardPath(context, this.path);
        this.forward(context, realpath);
    }

    protected String buildForwardPath(WebContext context, String path) {
        UrlBuilder builder = new UrlBuilder(path);
        Map<String, Object> params = ((Request)context.getRequest()).getAttributesAsMap();
        if (!params.isEmpty()) {
            builder.addAll(params);
        }
        return builder.build();
    }

    protected void forward(WebContext context, String path) {
        context.forward(path);
    }
}

