/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.t2.navigation;

import java.util.Map;
import org.t2framework.commons.meta.Config;
import org.t2framework.commons.util.Logger;
import org.t2framework.commons.util.UrlBuilder;
import org.t2framework.t2.annotation.core.ForwardTo;
import org.t2framework.t2.contexts.Request;
import org.t2framework.t2.contexts.WebContext;
import org.t2framework.t2.exception.NoForwardToAnnotationException;
import org.t2framework.t2.navigation.Redirect;
import org.t2framework.t2.navigation.WebNavigation;
import org.t2framework.t2.util.PathUtil;

public class Forward
extends WebNavigation {
    private static Logger logger = Logger.getLogger(Redirect.class);

    public static Forward to(Class<?> pageClass) {
        return new Forward(pageClass);
    }

    public static Forward to(String path) {
        return new Forward(path);
    }

    public Forward(String path) {
        super(path);
    }

    public Forward(Class<?> pageClass) {
        super(pageClass);
    }

    @Override
    public void execute(WebContext context) throws Exception {
        String path = null;
        Class<?> pageClass = this.getPageClass();
        if (pageClass != null) {
            Config cd = this.classDesc.findConfig(ForwardTo.class);
            if (cd == null || !cd.hasAnnotation()) {
                throw new NoForwardToAnnotationException(pageClass);
            }
            ForwardTo forwardTo = (ForwardTo)cd.getAnnotation();
            path = forwardTo.value();
        } else {
            path = this.getPath();
        }
        if (!path.startsWith("/")) {
            logger.log("ITDT0020", new Object[]{"Forward"});
            path = PathUtil.appendStartSlashIfNeed(path);
        }
        String realpath = this.buildForwardPath(context, path);
        this.forward(context, realpath);
    }

    protected String buildForwardPath(WebContext context, String path) {
        UrlBuilder builder = new UrlBuilder(path);
        Map<String, String[]> parameters = ((Request)context.getRequest()).getParametersAsMap();
        if (!parameters.isEmpty() && path.indexOf(63) < 0) {
            for (Map.Entry<String, String[]> entry : parameters.entrySet()) {
                String key = entry.getKey();
                String[] value = entry.getValue();
                if (value != null && value.length == 1) {
                    builder.add(key, (Object)value[0]);
                    continue;
                }
                builder.add(key, (Object)value);
            }
        }
        return builder.build();
    }

    protected void forward(WebContext context, String path) {
        context.forward(path);
    }
}

