/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.t2.filter;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.t2framework.commons.util.Logger;
import org.t2framework.t2.action.ActionInvoker;
import org.t2framework.t2.action.ActionInvokerFactory;
import org.t2framework.t2.action.impl.ActionInvokerFactoryImpl;
import org.t2framework.t2.action.impl.ActionInvokingContextImpl;
import org.t2framework.t2.contexts.PageDesc;
import org.t2framework.t2.contexts.WebApplication;
import org.t2framework.t2.contexts.WebConfiguration;
import org.t2framework.t2.contexts.WebContext;
import org.t2framework.t2.contexts.impl.WebConfigurationImpl;
import org.t2framework.t2.development.DevelopmentUtil;
import org.t2framework.t2.development.Mode;
import org.t2framework.t2.development.view.ViewDevelopmentActionInvokerFactoryImpl;
import org.t2framework.t2.navigation.PassThrough;
import org.t2framework.t2.plugin.PluginProcessor;
import org.t2framework.t2.plugin.impl.PluginProcessorImpl;
import org.t2framework.t2.spi.Navigation;

public class T2Filter
implements Filter {
    protected Logger log = Logger.getLogger(T2Filter.class);
    protected WebConfiguration webConfig;
    protected PluginProcessor pluginProcessor;
    protected volatile List<? extends ActionInvoker> actionInvokerList;

    public void init(FilterConfig config) throws ServletException {
        try {
            WebConfigurationImpl webConfig = new WebConfigurationImpl(config);
            webConfig.initialize();
            PluginProcessorImpl pluginProcessor = new PluginProcessorImpl(webConfig.getContainerAdapter());
            pluginProcessor.invokeInit(webConfig.getServletContext(), webConfig.getWebApplication());
            this.webConfig = webConfig;
            this.pluginProcessor = pluginProcessor;
        }
        catch (Throwable t) {
            throw new ServletException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        WebConfiguration webConfig = this.getWebConfig();
        PluginProcessor pluginProcessor = this.getPluginProcessor();
        webConfig.setupRequestAndResponse(req, res);
        pluginProcessor.beginRequest(req, res);
        WebContext context = null;
        try {
            ActionInvokingContextImpl invokingContext;
            ActionInvoker invoker;
            req = pluginProcessor.createRequest(req, res);
            res = pluginProcessor.createResponse(req, res);
            WebApplication webapp = webConfig.getWebApplication();
            FilterConfig filterConfig = webConfig.getFilterConfig();
            context = webapp.createContext(req, res, chain, filterConfig);
            if (this.isExcludeRequest(req)) {
                this.handleNotT2Request(context);
                return;
            }
            Navigation navigation = null;
            Iterator<? extends ActionInvoker> i$ = this.getActionInvokerList().iterator();
            while (i$.hasNext() && (navigation = (invoker = i$.next()).invoke(invokingContext = new ActionInvokingContextImpl(context, webConfig, pluginProcessor))) == null) {
            }
            if (navigation != null) {
                this.handleNavigation(navigation, pluginProcessor, context);
            } else {
                this.handleNotT2Request(context);
            }
        }
        catch (Throwable t) {
            webConfig.getGlobalExceptionHandler().handleException(t, context);
        }
        finally {
            try {
                pluginProcessor.endRequest(req, res);
            }
            finally {
                WebContext.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleNavigation(Navigation navigation, PluginProcessor processor, WebContext context) throws Throwable {
        try {
            processor.beforeNavigation(context);
            navigation.execute(context);
        }
        finally {
            processor.afterNavigation(context);
        }
    }

    public void destroy() {
        this.getPluginProcessor().destroy(this.webConfig.getServletContext(), this.webConfig.getWebApplication());
        this.webConfig.destroy();
        this.webConfig = null;
        this.pluginProcessor = null;
    }

    protected boolean isExcludeRequest(HttpServletRequest req) {
        String[] excludes;
        String uri = req.getRequestURI();
        for (String exclude : excludes = this.webConfig.getExcludeResources()) {
            if (!uri.endsWith(exclude)) continue;
            return true;
        }
        return false;
    }

    protected void handleNotT2Request(WebContext context) throws Exception {
        this.getOtherRequestNavigation().execute(context);
    }

    protected Navigation getOtherRequestNavigation() throws Exception {
        return PassThrough.pass();
    }

    protected WebConfiguration getWebConfig() {
        return this.webConfig;
    }

    protected PluginProcessor getPluginProcessor() {
        return this.pluginProcessor;
    }

    protected List<? extends ActionInvoker> getActionInvokerList() {
        this.initActionInvokerList();
        return this.actionInvokerList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initActionInvokerList() {
        if (this.actionInvokerList != null) {
            return;
        }
        T2Filter t2Filter = this;
        synchronized (t2Filter) {
            if (this.actionInvokerList != null) {
                return;
            }
            Map<String, PageDesc> pageDescMap = this.getWebConfig().getWebApplication().createPageDescMap();
            List<? extends ActionInvoker> invokerList = this.getActionInvokerFactory().createActionInvoker(this.getWebConfig());
            Map<String, PageDesc> unmodifiedMap = Collections.unmodifiableMap(pageDescMap);
            for (ActionInvoker actionInvoker : invokerList) {
                actionInvoker.initialize(this.getWebConfig(), unmodifiedMap);
            }
            this.actionInvokerList = invokerList;
        }
    }

    protected ActionInvokerFactory getActionInvokerFactory() {
        ActionInvokerFactory factory = null;
        try {
            factory = this.getWebConfig().getFrameworkComponent(ActionInvokerFactory.class);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (factory == null) {
            factory = DevelopmentUtil.getMode() == Mode.VIEW_DEVELOPMENT ? ViewDevelopmentActionInvokerFactoryImpl.getInstance() : ActionInvokerFactoryImpl.getInstance();
        }
        return factory;
    }
}

