/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.t2.filter;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.t2framework.commons.util.ServletUtil;
import org.t2framework.commons.util.StringUtil;
import org.t2framework.t2.filter.T2ConfigurationUtil;
import org.t2framework.t2.spi.MultipartRequestHandler;

public class MultiPartRequestFilter
implements Filter {
    public static final int DEFAULT_MAX_SIZE = 0x6400000;
    public static final int DEFAULT_MAX_FILE_SIZE = 0x6400000;
    public static final int DEFAULT_THREASHOLD_SIZE = 102400;
    public static int maxSize;
    public static int maxFileSize;
    public static int thresholdSize;
    public static String repositoryPath;
    public static String encoding;
    public static MultipartRequestHandler handler;

    public void init(FilterConfig filterConfig) throws ServletException {
        maxSize = ServletUtil.getSizeParameter((FilterConfig)filterConfig, (String)"uploadMaxSize", (int)0x6400000);
        maxFileSize = ServletUtil.getSizeParameter((FilterConfig)filterConfig, (String)"uploadMaxFileSize", (int)0x6400000);
        thresholdSize = ServletUtil.getSizeParameter((FilterConfig)filterConfig, (String)"uploadThresholdSize", (int)102400);
        repositoryPath = filterConfig.getInitParameter("uploadRepositoryPath");
        encoding = T2ConfigurationUtil.getEncoding(filterConfig);
        handler = T2ConfigurationUtil.getMultipartRequestHandler(filterConfig);
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        if (ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
            this.setupEncoding(request);
            request = this.createHttpServletRequestWrapper(request, handler);
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    protected HttpServletRequest createHttpServletRequestWrapper(HttpServletRequest request, MultipartRequestHandler handler) {
        return new MultiPartRequestWrapper(request, handler);
    }

    public void destroy() {
    }

    protected void setupEncoding(HttpServletRequest request) throws UnsupportedEncodingException {
        if (request.getCharacterEncoding() == null) {
            request.setCharacterEncoding(encoding);
        }
    }

    protected int getSizeParameter(FilterConfig filterConfig, String parameterName, int defaultValue) {
        String param = filterConfig.getInitParameter(parameterName);
        if (StringUtil.isEmpty((String)param)) {
            return defaultValue;
        }
        param = param.toLowerCase();
        int factor = 1;
        String number = param;
        if (StringUtil.endsWithIgnoreCase((String)param, (String)"g")) {
            factor = 0x40000000;
            number = param.substring(0, param.length() - 1);
        } else if (StringUtil.endsWithIgnoreCase((String)param, (String)"m")) {
            factor = 0x100000;
            number = param.substring(0, param.length() - 1);
        } else if (StringUtil.endsWithIgnoreCase((String)param, (String)"k")) {
            factor = 1024;
            number = param.substring(0, param.length() - 1);
        }
        return Integer.parseInt(number) * factor;
    }

    static {
        repositoryPath = null;
    }

    public static class MultiPartRequestWrapper
    extends HttpServletRequestWrapper {
        private Map<String, String[]> paramMap;

        public MultiPartRequestWrapper(HttpServletRequest request, MultipartRequestHandler handler) {
            super(request);
            this.paramMap = handler.handle(request);
        }

        public String getParameter(String name) {
            String value = (String)this.getFirst(this.paramMap.get(name));
            if (value == null) {
                value = super.getParameter(name);
            }
            return value;
        }

        public Map getParameterMap() {
            return this.paramMap;
        }

        public Enumeration getParameterNames() {
            return Collections.enumeration(this.paramMap.keySet());
        }

        public String[] getParameterValues(String name) {
            return this.paramMap.get(name);
        }

        protected Object getFirst(Object obj) {
            Object[] objs = (Object[])obj;
            if (objs == null || objs.length == 0) {
                return null;
            }
            return objs[0];
        }
    }
}

