/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.t2.development.view;

import java.io.File;
import java.util.Properties;
import org.t2framework.commons.annotation.composite.SingletonScope;
import org.t2framework.commons.util.StringUtil;
import org.t2framework.t2.annotation.core.Ajax;
import org.t2framework.t2.annotation.core.Default;
import org.t2framework.t2.annotation.core.Page;
import org.t2framework.t2.contexts.Request;
import org.t2framework.t2.navigation.Forward;
import org.t2framework.t2.navigation.Json;
import org.t2framework.t2.spi.Navigation;
import org.t2framework.t2.util.PathUtil;

@SingletonScope
@Page(value=".*")
public class ViewDevelopmentPage {
    public static final String WELCOME_FILE_KEY = "welcome.file";
    public static final String VIEW_PREFIX_KEY = "view.prefix";
    public static final String VIEW_SUFFIX_KEY = "view.suffix";
    public static final String VIEW_DEVELOPMENT_CUSTOM_PAGE_KEY = "view.development.custom.page";
    public static final String JSON_DATA_KEY = "json.data";
    public static final String DEFAULT_WELCOME_FILE = "/index.jsp";
    public static final String DEFAULT_VIEW_PREFIX = "/jsp";
    public static final String DEFAULT_VIEW_SUFFIX = ".jsp";
    public static final String DEFAULT_VIEW_DEVELOPMENT_CUSTOM_PAGE = ViewDevelopmentPage.class.getName();
    public static Properties appProperties;

    public static String getWelcomeFile() {
        return appProperties.getProperty(WELCOME_FILE_KEY, DEFAULT_WELCOME_FILE);
    }

    public static String getViewPrefix() {
        String prefix = appProperties.getProperty(VIEW_PREFIX_KEY, DEFAULT_VIEW_PREFIX);
        return prefix.endsWith("/") ? prefix : prefix + "/";
    }

    public static String getViewSuffix() {
        return appProperties.getProperty(VIEW_SUFFIX_KEY, DEFAULT_VIEW_SUFFIX);
    }

    public static String getJsonDataPath() {
        return appProperties.getProperty(JSON_DATA_KEY);
    }

    @Default
    public Navigation executeGet(Request request) {
        String viewPath = PathUtil.getPagePath(request);
        String viewPrefix = ViewDevelopmentPage.getViewPrefix();
        String viewSuffix = ViewDevelopmentPage.getViewSuffix();
        if (StringUtil.isEmpty((String)viewPath)) {
            viewPath = ViewDevelopmentPage.getWelcomeFile();
        } else if (!viewPath.endsWith(viewSuffix)) {
            viewPath = viewPrefix + viewPath + viewSuffix;
        }
        return Forward.to(viewPath);
    }

    @Ajax
    public Navigation executeAjax(Request request) {
        String jsonPath = ViewDevelopmentPage.getJsonDataPath();
        if (!StringUtil.isEmpty((String)jsonPath)) {
            File file = new File(jsonPath);
            return Json.convert(file);
        }
        return Json.convert("no such data");
    }
}

