/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.t2.development.view;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.t2framework.commons.util.Logger;
import org.t2framework.commons.util.Reflections;
import org.t2framework.t2.action.ActionInvoker;
import org.t2framework.t2.action.ActionInvokerFactory;
import org.t2framework.t2.action.PageDescFinder;
import org.t2framework.t2.action.impl.ActionInvokerFactoryImpl;
import org.t2framework.t2.action.impl.ActionInvokerImpl;
import org.t2framework.t2.adapter.ContainerAdapter;
import org.t2framework.t2.annotation.core.Page;
import org.t2framework.t2.contexts.PageDesc;
import org.t2framework.t2.contexts.WebConfiguration;
import org.t2framework.t2.contexts.WebContext;
import org.t2framework.t2.contexts.impl.PageDescImpl;
import org.t2framework.t2.development.DevelopmentUtil;
import org.t2framework.t2.development.Mode;
import org.t2framework.t2.development.view.ViewDevelopmentPage;
import org.t2framework.t2.development.view.ViewDevelopmentUrlTemplateFactoryImpl;
import org.t2framework.t2.spi.AnnotationResolverCreator;
import org.t2framework.t2.util.UrlTemplateFactory;

public class ViewDevelopmentActionInvokerFactoryImpl
implements ActionInvokerFactory {
    protected static Logger logger = Logger.getLogger(ViewDevelopmentActionInvokerFactoryImpl.class);
    protected static final ViewDevelopmentActionInvokerFactoryImpl INSTANCE = new ViewDevelopmentActionInvokerFactoryImpl();
    protected static final UrlTemplateFactory factory = new ViewDevelopmentUrlTemplateFactoryImpl();

    public static ActionInvokerFactory getInstance() {
        return INSTANCE;
    }

    public ViewDevelopmentActionInvokerFactoryImpl() {
        logger.debug("org.t2framework.t2.design", this.getClass().getSimpleName() + " is created for view development.");
    }

    @Override
    public List<? extends ActionInvoker> createActionInvoker(final WebConfiguration webConfig) {
        if (DevelopmentUtil.getMode() != Mode.VIEW_DEVELOPMENT) {
            return ActionInvokerFactoryImpl.getInstance().createActionInvoker(webConfig);
        }
        logger.debug("org.t2framework.t2.boundary", "Create ActionInvoker for view development.");
        final AnnotationResolverCreator resolverCreator = webConfig.getResolverCreator();
        return Arrays.asList(new ActionInvokerImpl(){

            @Override
            public PageDescFinder getPageDescFinder() {
                return new PageDescFinder(){

                    @Override
                    public void initialize(Map<String, PageDesc> pageDescMap) {
                    }

                    @Override
                    public List<PageDesc> find(WebContext context) {
                        Properties applicationProperties;
                        Class<? extends ViewDevelopmentPage> viewDevelopmentClass;
                        ContainerAdapter<?> containerAdapter = webConfig.getContainerAdapter();
                        if (!containerAdapter.hasComponent(viewDevelopmentClass = this.findCustomOne(applicationProperties = DevelopmentUtil.getApplicationProperties(true)))) {
                            containerAdapter.register(viewDevelopmentClass);
                        }
                        ViewDevelopmentPage.appProperties = applicationProperties;
                        String pageTemplatePath = viewDevelopmentClass.getAnnotation(Page.class).value();
                        PageDescImpl pageDesc = new PageDescImpl(viewDevelopmentClass, factory.getUrlTemplate(pageTemplatePath), resolverCreator.getActionAnnotationSet(containerAdapter));
                        return Arrays.asList(pageDesc);
                    }

                    protected Class<? extends ViewDevelopmentPage> findCustomOne(Properties applicationProperties) {
                        String className = applicationProperties.getProperty("view.development.custom.page", ViewDevelopmentPage.DEFAULT_VIEW_DEVELOPMENT_CUSTOM_PAGE);
                        return Reflections.ClassUtil.forName((String)className);
                    }
                };
            }
        });
    }
}

