/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.t2.development;

import org.t2framework.commons.util.StringUtil;

public enum Mode {
    VIEW_DEVELOPMENT,
    DEVELOPMENT,
    PRODUCTION;

    public static final String MODE_KEY = "mode";

    public String toString() {
        return this.name().toLowerCase();
    }

    public static boolean isViewDevelopmentMode(String status) {
        return Mode.isMode(status, VIEW_DEVELOPMENT);
    }

    public static boolean isDevelopmentMode(String status) {
        return Mode.isMode(status, DEVELOPMENT);
    }

    public static boolean isProductionMode(String status) {
        return Mode.isMode(status, PRODUCTION);
    }

    private static boolean isMode(String status, Mode mode) {
        if (StringUtil.isEmpty((String)status)) {
            return false;
        }
        return status.toLowerCase().equals(mode.toString());
    }

    public static Mode toMode(String status) {
        if (Mode.isViewDevelopmentMode(status)) {
            return VIEW_DEVELOPMENT;
        }
        if (Mode.isDevelopmentMode(status)) {
            return DEVELOPMENT;
        }
        return PRODUCTION;
    }
}

