/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.t2.development;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.t2framework.commons.util.ResourceUtil;
import org.t2framework.t2.development.Mode;

public class DevelopmentUtil {
    public static Properties applicationProperties = new Properties();
    protected static Mode testMode;

    public static void load() {
        InputStream is = ResourceUtil.getResourceAsStreamNoException((String)"app.properties");
        if (is != null) {
            try {
                applicationProperties.load(is);
            }
            catch (IOException ignore) {
                applicationProperties.setProperty("mode", Mode.PRODUCTION.toString());
            }
        } else {
            applicationProperties.setProperty("mode", Mode.PRODUCTION.toString());
        }
    }

    public static synchronized void reload() {
        applicationProperties.clear();
        DevelopmentUtil.load();
    }

    public static Properties getApplicationProperties(boolean reload) {
        DevelopmentUtil.reload();
        return applicationProperties;
    }

    public static Mode getMode() {
        if (testMode != null) {
            return testMode;
        }
        return Mode.toMode(applicationProperties.getProperty("mode"));
    }

    public static void setMode(Mode mode) {
        testMode = mode;
    }

    static {
        DevelopmentUtil.load();
    }
}

