/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.t2.contexts.impl;

import java.io.File;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.JarFile;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.t2framework.commons.Constants;
import org.t2framework.commons.exception.NoSuchComponentException;
import org.t2framework.commons.meta.BeanDesc;
import org.t2framework.commons.meta.ClassDesc;
import org.t2framework.commons.meta.Config;
import org.t2framework.commons.meta.impl.ClassDescImpl;
import org.t2framework.commons.util.Assertion;
import org.t2framework.commons.util.CollectionsUtil;
import org.t2framework.commons.util.JarFileUtil;
import org.t2framework.commons.util.Logger;
import org.t2framework.commons.util.Reflections;
import org.t2framework.commons.util.ResourceUtil;
import org.t2framework.commons.util.StringUtil;
import org.t2framework.commons.util.Traversal;
import org.t2framework.commons.util.URLUtil;
import org.t2framework.commons.util.ZipFileUtil;
import org.t2framework.t2.adapter.ContainerAdapter;
import org.t2framework.t2.annotation.core.Page;
import org.t2framework.t2.contexts.Application;
import org.t2framework.t2.contexts.Chain;
import org.t2framework.t2.contexts.PageDesc;
import org.t2framework.t2.contexts.Request;
import org.t2framework.t2.contexts.Response;
import org.t2framework.t2.contexts.Session;
import org.t2framework.t2.contexts.WebApplication;
import org.t2framework.t2.contexts.WebConfiguration;
import org.t2framework.t2.contexts.WebContext;
import org.t2framework.t2.contexts.impl.ApplicationImpl;
import org.t2framework.t2.contexts.impl.ChainImpl;
import org.t2framework.t2.contexts.impl.ContextImpl;
import org.t2framework.t2.contexts.impl.PageDescImpl;
import org.t2framework.t2.contexts.impl.RequestImpl;
import org.t2framework.t2.contexts.impl.ResponseImpl;
import org.t2framework.t2.contexts.impl.SessionImpl;
import org.t2framework.t2.spi.AnnotationResolverCreator;
import org.t2framework.t2.util.UrlTemplate;
import org.t2framework.t2.util.impl.UrlTemplateImpl;

public class WebApplicationImpl
implements WebApplication,
Traversal.ClassHandler {
    protected static final String CLASS_NAME = WebApplicationImpl.class.getName();
    protected static Logger logger = Logger.getLogger((String)CLASS_NAME);
    protected static Logger success = Logger.getLogger((String)(CLASS_NAME + ".success"));
    protected static Logger ignored = Logger.getLogger((String)(CLASS_NAME + ".ignored"));
    protected ContainerAdapter<?> adapter;
    protected String[] rootPackages;
    protected boolean eagerload;
    protected ConcurrentHashMap<String, PageDesc> pageDescMap = new ConcurrentHashMap();
    protected Map<String, Strategy> strategies = new HashMap<String, Strategy>();
    protected Map<Class, UrlTemplate> classCache = CollectionsUtil.newConcurrentHashMap();
    protected boolean amfEnabled = false;
    protected final AnnotationResolverCreator resolverCreator;

    public WebApplicationImpl(WebConfiguration config) {
        this(config.getContainerAdapter(), config.getRootPackages(), config.getEagerLoad(), config.getResolverCreator());
    }

    public WebApplicationImpl(ContainerAdapter<?> adapter, String[] rootPackages, boolean eagerload, AnnotationResolverCreator resolverCreator) {
        this.adapter = (ContainerAdapter)Assertion.notNull(adapter, (String)"adapter");
        this.rootPackages = (String[])Assertion.notNull((Object)rootPackages);
        this.eagerload = eagerload;
        this.resolverCreator = (AnnotationResolverCreator)Assertion.notNull((Object)resolverCreator);
    }

    @Override
    public void initialize() {
        this.setupStrategies();
        this.traverse();
    }

    protected void setupStrategies() {
        this.addStrategy("file", new FileSystemStrategy());
        this.addStrategy("jar", new JarFileStrategy());
        this.addStrategy("wsjar", new JarFileStrategy());
        this.addStrategy("zip", new ZipFileStrategy());
        this.addStrategy("vfszip", new VfsZipFileStrategy());
        this.addStrategy("code-source", new CodeSourceFileStrategy());
    }

    protected void addStrategy(String protocol, Strategy strategy) {
        this.strategies.put(protocol, strategy);
    }

    protected synchronized void traverse() {
        logger.log("ITDT0026");
        for (String rootPackage : this.rootPackages) {
            String path = rootPackage.replace('.', '/');
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Enumeration resources = ResourceUtil.getResources((ClassLoader)loader, (String)path);
            while (resources.hasMoreElements()) {
                File file;
                URL u = (URL)resources.nextElement();
                String externalForm = u.toExternalForm();
                String filepath = u.getFile();
                filepath = URLUtil.decode((String)filepath, (String)"UTF8");
                logger.log("ITDT0035", new Object[]{rootPackage, externalForm});
                if (filepath.startsWith("file:")) {
                    filepath = filepath.substring(Constants.FILE_URL_PREFIX_LENGTH);
                }
                if (0 < filepath.indexOf("!")) {
                    filepath = filepath.substring(0, filepath.indexOf("!"));
                }
                if ((file = new File(filepath)).isDirectory()) {
                    this.loadFromFilesystem(path, file, u);
                    continue;
                }
                this.loadFromJar(path, file, u);
            }
        }
        logger.log("ITDT0027");
    }

    protected void loadFromFilesystem(String packagename, File file, URL url) {
        this.strategies.get("file").handle(packagename, file, url, this);
    }

    protected void loadFromJar(String packagename, File file, URL url) {
        String protocol = url.getProtocol();
        Strategy strategy = this.strategies.get(protocol);
        if (strategy == null) {
            throw new NullPointerException();
        }
        strategy.handle(packagename, file, url, this);
    }

    @Override
    public WebContext createContext(HttpServletRequest req, HttpServletResponse res, FilterChain filterChain, FilterConfig config) {
        Request request = this.createRequest(req, res, this.amfEnabled);
        Response response = this.createResponse(res);
        Session session = this.createSession(request);
        Application application = this.createApplication(config);
        Chain chain = this.createChain(filterChain);
        ContextImpl context = this.createContext(request, response, application, session, chain);
        context.setContainerAdapter(this.getContainerAdapter());
        WebContext.set(context);
        return context;
    }

    protected ContextImpl createContext(Request request, Response response, Application application, Session session, Chain chain) {
        return new ContextImpl(request, response, application, session, chain);
    }

    protected Chain createChain(FilterChain filterChain) {
        return new ChainImpl(filterChain);
    }

    protected Application createApplication(FilterConfig config) {
        return new ApplicationImpl(config.getServletContext(), config);
    }

    protected Session createSession(Request request) {
        return new SessionImpl(request);
    }

    protected Request createRequest(HttpServletRequest req, HttpServletResponse res, boolean amfEnabled) {
        return new RequestImpl(req, res, amfEnabled);
    }

    protected Response createResponse(HttpServletResponse res) {
        return new ResponseImpl(res);
    }

    public void processClass(String packageName, String shortClassName) {
        logger.log("ITDT0028", new Object[]{packageName, shortClassName});
        if (packageName == null || shortClassName == null) {
            ignored.log("ITDT0029", new Object[]{packageName, shortClassName});
            return;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(packageName.replace('/', '.'));
        builder.append(".");
        builder.append(shortClassName);
        Class c = Reflections.ClassUtil.forNameNoException((String)builder.toString());
        if (c == null) {
            ignored.log("ITDT0037", new Object[]{packageName, shortClassName});
            return;
        }
        if (c.isAnnotation() || c.isEnum()) {
            ignored.log("ITDT0030", new Object[]{packageName, shortClassName});
            return;
        }
        int mod = c.getModifiers();
        if (Modifier.isInterface(mod) || Modifier.isAbstract(mod) || !Modifier.isPublic(mod)) {
            ignored.log("ITDT0031", new Object[]{packageName, shortClassName});
            return;
        }
        ClassDescImpl cd = new ClassDescImpl(c);
        this.processPage((ClassDesc<?>)cd);
    }

    protected void processPage(ClassDesc<?> cd) {
        if (!cd.hasConfig(Page.class)) {
            return;
        }
        Class c = cd.getConcreteClass();
        String className = c.getName();
        Config pageConfig = cd.findConfig(Page.class);
        Page page = (Page)pageConfig.getAnnotation();
        if (page == null) {
            ignored.log("ITDT0032", new Object[]{className});
            return;
        }
        String path = page.value();
        if (StringUtil.isEmpty((String)path)) {
            String name = Reflections.ClassUtil.getShortClassName((Class)c);
            path = StringUtil.decapitalize((String)name);
        }
        if (this.eagerload) {
            logger.log("ITDT0033", new Object[]{className});
            ContainerAdapter<?> adapter = this.getContainerAdapter();
            adapter.register(c);
        }
        UrlTemplateImpl template = new UrlTemplateImpl(path);
        success.log("ITDT0034", new Object[]{className});
        this.classCache.put(c, template);
    }

    protected ContainerAdapter<?> getContainerAdapter() {
        return this.adapter;
    }

    @Override
    public Map<String, PageDesc> createPageDescMap() {
        if (this.pageDescMap.isEmpty()) {
            this.loadPageDescMap();
        }
        return this.pageDescMap;
    }

    protected void loadPageDescMap() {
        for (Class key : this.classCache.keySet()) {
            UrlTemplate template = this.classCache.get(key);
            BeanDesc beanDesc = this.adapter.getBeanDesc(key);
            if (beanDesc == null) {
                throw new NoSuchComponentException((Object)key.getName());
            }
            PageDescImpl pd = new PageDescImpl(Reflections.PackageUtil.getPackageName((Class)key), Reflections.ClassUtil.getSimpleClassName((Class)key), beanDesc, template, this.resolverCreator.getActionAnnotationSet(this.adapter));
            this.pageDescMap.putIfAbsent(key.getName(), pd);
        }
    }

    @Override
    public String[] getRootPackages() {
        return this.rootPackages;
    }

    @Override
    public void destroy() {
        this.adapter = null;
        this.rootPackages = null;
        this.eagerload = false;
        this.pageDescMap.clear();
        this.classCache.clear();
        this.strategies.clear();
    }

    protected static class VfsZipFileStrategy
    implements Strategy {
        protected VfsZipFileStrategy() {
        }

        @Override
        public void handle(String packagename, File root, URL url, Traversal.ClassHandler handler) {
            JarFile jarFile = this.createJarFile(url);
            Traversal.traverseFromJarFile((JarFile)jarFile, (Traversal.ClassHandler)handler);
        }

        protected JarFile createJarFile(URL url) {
            String path = url.getPath();
            String pathUp = path.toUpperCase();
            String warUp = ".war".toUpperCase();
            String warPath = path.substring(0, pathUp.indexOf(warUp) + ".war".length());
            return JarFileUtil.create((String)warPath);
        }
    }

    protected static class CodeSourceFileStrategy
    implements Strategy {
        protected CodeSourceFileStrategy() {
        }

        @Override
        public void handle(String packagename, File root, URL url, Traversal.ClassHandler handler) {
            JarFile jarFile = this.createJarFile(url);
            Traversal.traverseFromJarFile((JarFile)jarFile, (Traversal.ClassHandler)handler);
        }

        protected JarFile createJarFile(URL url) {
            URL jarUrl = URLUtil.create((String)("jar:file:" + url.getPath()));
            return JarFileUtil.toJarFile((URL)jarUrl);
        }
    }

    protected static class ZipFileStrategy
    implements Strategy {
        protected ZipFileStrategy() {
        }

        @Override
        public void handle(String packagename, File root, URL url, Traversal.ClassHandler handler) {
            JarFile jarFile = this.createJarFile(url);
            Traversal.traverseFromJarFile((JarFile)jarFile, (Traversal.ClassHandler)handler);
        }

        protected JarFile createJarFile(URL url) {
            String jarFileName = ZipFileUtil.toZipFilePath((URL)url);
            return JarFileUtil.create((File)new File(jarFileName));
        }
    }

    protected static class JarFileStrategy
    implements Strategy {
        protected JarFileStrategy() {
        }

        @Override
        public void handle(String packagename, File root, URL url, Traversal.ClassHandler handler) {
            JarFile jarFile = this.createJarFile(url);
            Traversal.traverseFromJarFile((JarFile)jarFile, (Traversal.ClassHandler)handler);
        }

        protected JarFile createJarFile(URL url) {
            return JarFileUtil.toJarFile((URL)url);
        }
    }

    protected static class FileSystemStrategy
    implements Strategy {
        protected FileSystemStrategy() {
        }

        @Override
        public void handle(String packagename, File root, URL url, Traversal.ClassHandler handler) {
            File[] files = root.listFiles();
            StringBuilder builder = null;
            if (files == null) {
                return;
            }
            for (File f : files) {
                String packageOrClass;
                builder = new StringBuilder(100);
                String name = f.getName();
                builder.append(packagename).append("/").append(name);
                String string = packageOrClass = root == null ? name : builder.toString();
                if (f.isDirectory()) {
                    this.handle(packageOrClass, f, url, handler);
                    continue;
                }
                if (!name.endsWith(".class")) continue;
                String className = packageOrClass.substring(0, packageOrClass.length() - ".class".length()).replace('/', '.');
                int pos = className.lastIndexOf(46);
                String shortClassName = pos == -1 ? className : className.substring(pos + 1);
                handler.processClass(packagename, shortClassName);
            }
        }
    }

    protected static interface Strategy {
        public void handle(String var1, File var2, URL var3, Traversal.ClassHandler var4);
    }
}

