/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.t2.contexts.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.util.Streams;
import org.t2framework.t2.contexts.UploadFile;

public class StreamUploadFileImpl
implements UploadFile {
    protected byte[] bytes = new byte[0];
    protected String contentType;
    protected String name;

    public StreamUploadFileImpl(FileItemStream fileItemStream) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Streams.copy((InputStream)fileItemStream.openStream(), (OutputStream)baos, (boolean)true);
        this.bytes = baos.toByteArray();
        this.contentType = fileItemStream.getContentType();
        this.name = fileItemStream.getName();
    }

    @Override
    public byte[] get() {
        return this.bytes;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.bytes);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public long getSize() {
        return this.bytes.length;
    }

    @Override
    public String getString() throws UnsupportedEncodingException {
        return this.getString("UTF-8");
    }

    @Override
    public String getString(String encoding) throws UnsupportedEncodingException {
        return new String(this.bytes, encoding);
    }

    public String toString() {
        return this.getName();
    }

    protected String getBaseFileName(String filePath) {
        String fileName = new File(filePath).getName();
        int colonIndex = fileName.indexOf(":");
        if (colonIndex == -1) {
            colonIndex = fileName.indexOf("\\\\");
        }
        int backslashIndex = fileName.lastIndexOf("\\");
        if (colonIndex > -1 && backslashIndex > -1) {
            fileName = fileName.substring(backslashIndex + 1);
        }
        return fileName;
    }
}

