/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.t2.contexts.impl;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Set;
import org.t2framework.commons.meta.BeanDesc;
import org.t2framework.commons.meta.MethodDesc;
import org.t2framework.commons.meta.PropertyDesc;
import org.t2framework.commons.util.Assertion;
import org.t2framework.t2.annotation.core.Default;
import org.t2framework.t2.contexts.ActionMethodDesc;
import org.t2framework.t2.contexts.impl.ActionMethodDescImpl;

public class ActionMethodUtil {
    public static ActionMethodDesc createActionMethodDesc(BeanDesc<?> pbd, Set<Class<? extends Annotation>> actionAnnotationSet) {
        Assertion.notNull(pbd);
        Assertion.notNull(actionAnnotationSet);
        ActionMethodDescImpl amd = new ActionMethodDescImpl(actionAnnotationSet);
        List methodDescList = pbd.getAllMethodDesc();
        for (MethodDesc md : methodDescList) {
            ActionMethodUtil.setupActionMethodDesc(md, amd, actionAnnotationSet);
        }
        for (PropertyDesc pd : pbd.getAllPropertyDesc()) {
            if (pd.isWritable()) {
                ActionMethodUtil.setupActionMethodDesc(pd.getWriteMethodDesc(), amd, actionAnnotationSet);
            }
            if (!pd.isReadable()) continue;
            ActionMethodUtil.setupActionMethodDesc(pd.getReadMethodDesc(), amd, actionAnnotationSet);
        }
        return amd;
    }

    protected static void setupActionMethodDesc(MethodDesc md, ActionMethodDesc amd, Set<Class<? extends Annotation>> actionAnnotationSet) {
        for (Class<? extends Annotation> annotationClass : actionAnnotationSet) {
            if (!md.hasConfig(annotationClass)) continue;
            amd.addTargetMethodDesc(md);
            return;
        }
    }

    public static MethodDesc resolveDefaultMethodDesc(BeanDesc<?> beanDesc) {
        for (MethodDesc md : beanDesc.getAllMethodDesc()) {
            if (!md.hasConfig(Default.class)) continue;
            return md;
        }
        for (PropertyDesc pd : beanDesc.getAllPropertyDesc()) {
            if (!pd.hasConfig(Default.class)) continue;
            return pd.isReadable() ? pd.getReadMethodDesc() : pd.getWriteMethodDesc();
        }
        return null;
    }
}

