/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.t2.contexts.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.t2framework.commons.Constants;
import org.t2framework.commons.meta.MethodDesc;
import org.t2framework.commons.util.Assertion;
import org.t2framework.commons.util.Reflections;
import org.t2framework.t2.contexts.ActionMethodDesc;

public class ActionMethodDescImpl
implements ActionMethodDesc {
    protected final Set<Class<? extends Annotation>> actionAnnotationSet;
    protected List<ActionInfo> list = new ArrayList<ActionInfo>();
    protected List<String> methodNameList = new ArrayList<String>();
    protected List<ActionInfo> unmodifiedList;
    protected Comparator<ActionInfo> comparator = new Comparator<ActionInfo>(){

        @Override
        public int compare(ActionInfo o1, ActionInfo o2) {
            if (o1 instanceof DefaultActionInfo) {
                return 1;
            }
            if (o2 instanceof DefaultActionInfo) {
                return -1;
            }
            String templatePath1 = o1.templatePath;
            String templatePath2 = o2.templatePath;
            int len = templatePath2.length() - templatePath1.length();
            if (len != 0) {
                return len;
            }
            return o2.annotationCounts - o1.annotationCounts;
        }
    };

    public ActionMethodDescImpl(Set<Class<? extends Annotation>> actionAnnotationSet) {
        this.actionAnnotationSet = actionAnnotationSet;
    }

    public ActionMethodDescImpl(Set<Class<? extends Annotation>> actionAnnotationSet, Comparator<ActionInfo> comparator) {
        this.actionAnnotationSet = actionAnnotationSet;
        this.comparator = comparator;
    }

    @Override
    public void addTargetMethodDesc(MethodDesc methodDesc) {
        Assertion.notNull((Object)methodDesc);
        String methodName = methodDesc.getMethodName();
        this.addTargetMethodDesc(methodName, methodDesc);
    }

    @Override
    public void addTargetMethodDesc(String alias, MethodDesc methodDesc) {
        Assertion.notNull((Object)alias);
        Assertion.notNull((Object)methodDesc);
        if (!this.list.contains(methodDesc)) {
            ActionInfo info = new ActionInfo(alias, methodDesc);
            this.list.add(info);
            this.methodNameList.add(alias);
        }
    }

    @Override
    public MethodDesc getMethodDesc(String methodName) {
        Assertion.notNull((Object)methodName);
        for (ActionInfo info : this.list) {
            if (!info.methodName.endsWith(methodName)) continue;
            return info.methodDesc;
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public int getMethodDescSize() {
        return this.list.size();
    }

    @Override
    public Set<String> getMethodNames() {
        return new HashSet<String>(this.methodNameList);
    }

    @Override
    public void addDefaultMethodDesc(MethodDesc methodDesc) {
        Assertion.notNull((Object)methodDesc);
        this.list.add(new DefaultActionInfo(methodDesc));
    }

    @Override
    public Iterator<MethodDesc> iterator() {
        return new Iterator<MethodDesc>(){
            protected int i = 0;

            @Override
            public boolean hasNext() {
                if (ActionMethodDescImpl.this.unmodifiedList.isEmpty()) {
                    return false;
                }
                return this.i < ActionMethodDescImpl.this.unmodifiedList.size();
            }

            @Override
            public MethodDesc next() {
                return ActionMethodDescImpl.this.unmodifiedList.get((int)this.i++).methodDesc;
            }

            @Override
            public void remove() {
            }
        };
    }

    @Override
    public boolean freeze() {
        this.unmodifiedList = this.setup(this.list);
        return this.unmodifiedList != null;
    }

    protected List<ActionInfo> setup(List<ActionInfo> list) {
        Collections.sort(list, this.comparator);
        return Collections.unmodifiableList(list);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getName());
        builder.append("@" + this.hashCode());
        builder.append("[");
        for (String methodName : this.methodNameList) {
            builder.append(methodName);
            builder.append(", ");
        }
        if (!this.methodNameList.isEmpty()) {
            builder.setLength(builder.length() - 2);
        }
        builder.append("]");
        return new String(builder);
    }

    protected class ActionInfo {
        public MethodDesc methodDesc;
        public String methodName;
        public int annotationCounts;
        public String templatePath;

        public ActionInfo(MethodDesc methodDesc) {
            this(methodDesc.getMethodName(), methodDesc);
        }

        public ActionInfo(String methodName, MethodDesc methodDesc) {
            this.methodDesc = methodDesc;
            this.methodName = methodName;
            this.init(methodDesc);
        }

        protected void init(MethodDesc methodDesc) {
            int count = 0;
            ArrayList<String> paths = new ArrayList<String>();
            for (Class<? extends Annotation> c : ActionMethodDescImpl.this.actionAnnotationSet) {
                if (!methodDesc.hasConfig(c)) continue;
                Method annotationMethod = this.getTemplatePathReturnMethod(c);
                if (annotationMethod != null && annotationMethod.getReturnType() == String.class) {
                    Annotation annotation = methodDesc.findConfig(c).getAnnotation();
                    try {
                        String templatePath = (String)annotationMethod.invoke((Object)annotation, Constants.EMPTY_ARRAY);
                        paths.add(templatePath);
                    }
                    catch (Throwable ignore) {
                        // empty catch block
                    }
                }
                ++count;
            }
            Collections.sort(paths, new Comparator<String>(){

                @Override
                public int compare(String s1, String s2) {
                    String pageTemplatePath2 = s2.replaceAll("\\{.*\\}", "");
                    String pageTemplatePath1 = s1.replaceAll("\\{.*\\}", "");
                    return pageTemplatePath2.length() - pageTemplatePath1.length();
                }
            });
            this.templatePath = 0 < paths.size() ? (String)paths.get(0) : "";
            this.annotationCounts = count;
        }

        protected Method getTemplatePathReturnMethod(Class<? extends Annotation> c) {
            return Reflections.MethodUtil.getDeclaredMethodNoException(c, (String)"value", (Class[])Constants.EMPTY_CLASS_ARRAY);
        }
    }

    protected class DefaultActionInfo
    extends ActionInfo {
        public DefaultActionInfo(MethodDesc methodDesc) {
            super(methodDesc);
        }
    }
}

