/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.t2.action.parameter.impl;

import java.lang.annotation.Annotation;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.t2framework.commons.meta.MethodDesc;
import org.t2framework.t2.action.ActionContext;
import org.t2framework.t2.action.parameter.AbstractParameterResolver;
import org.t2framework.t2.annotation.core.Var;
import org.t2framework.t2.contexts.Request;
import org.t2framework.t2.exception.VarParameterNotFoundRuntimeException;
import org.t2framework.t2.util.PathUtil;
import org.t2framework.t2.util.UrlTemplate;

public class VarParameterResolver
extends AbstractParameterResolver {
    public VarParameterResolver() {
        this.setTargetAnnotationClass(Var.class);
    }

    @Override
    public Object resolve(ActionContext actionContext, MethodDesc md, int paramIndex, Annotation[] paramAnnotations, Class<?> paramClass) {
        Var var = (Var)this.findTargetAnnotation(paramAnnotations, this.getTargetAnnotationClass());
        if (var == null) {
            throw new IllegalStateException("must have @Var annotation.");
        }
        String templateKey = "{" + var.value() + "}";
        boolean nullable = var.nullable();
        Request request = actionContext.getRequest();
        HttpServletRequest req = (HttpServletRequest)request.getNativeResource();
        String urlPath = PathUtil.getPagePath(req);
        Object value = this.getTemplatedValue(actionContext, md, urlPath, templateKey);
        if (value != null) {
            return value;
        }
        if (nullable) {
            return null;
        }
        throw new VarParameterNotFoundRuntimeException(templateKey);
    }

    protected Object getTemplatedValue(ActionContext actionContext, MethodDesc md, String urlPath, String templateKey) {
        for (UrlTemplate template : actionContext.getUrlTemplates(md)) {
            Map<String, String> map = template.parseUrl(urlPath);
            if (map == null || map.isEmpty() || !map.containsKey(templateKey)) continue;
            String s = map.get(templateKey);
            return actionContext.getRequest().decode(s);
        }
        return null;
    }
}

