/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.t2.action.parameter.impl;

import java.lang.annotation.Annotation;
import java.util.List;
import org.t2framework.commons.meta.MethodDesc;
import org.t2framework.t2.action.ActionContext;
import org.t2framework.t2.action.parameter.AbstractParameterResolver;
import org.t2framework.t2.annotation.core.Upload;
import org.t2framework.t2.contexts.Multipart;
import org.t2framework.t2.contexts.Request;
import org.t2framework.t2.contexts.UploadFile;
import org.t2framework.t2.exception.UploadFileNotFoundException;
import org.t2framework.t2.exception.UploadSettingsRuntimeException;

public class UploadFileParameterResolver
extends AbstractParameterResolver {
    public UploadFileParameterResolver() {
        this.setTargetAnnotationClass(Upload.class);
    }

    @Override
    public boolean isTargetParameter(ActionContext actionContext, MethodDesc md, int paramIndex, Annotation[] paramAnnotations, Class<?> paramClass) {
        return UploadFileParameterResolver.isUploadFile(paramClass);
    }

    @Override
    public Object resolve(ActionContext actionContext, MethodDesc md, int paramIndex, Annotation[] paramAnnotations, Class<?> paramClass) {
        UploadFileParameterResolver.assertUploadFile(paramClass);
        Upload upload = (Upload)this.findTargetAnnotation(paramAnnotations, this.targetAnnotationClass);
        UploadFile[] files = this.getUploadFiles(upload, actionContext.getRequest());
        if (paramClass.isArray()) {
            return files;
        }
        return this.getSingleUploadFile(files);
    }

    protected UploadFile getSingleUploadFile(UploadFile[] files) {
        if (files.length == 0) {
            throw new IllegalStateException();
        }
        return files[0];
    }

    protected static void assertUploadFile(Class<?> paramClass) {
        if (!UploadFileParameterResolver.isUploadFile(paramClass)) {
            throw new IllegalStateException();
        }
    }

    protected static boolean isUploadFile(Class<?> paramClass) {
        Class<?> target = paramClass.isArray() ? paramClass.getComponentType() : paramClass;
        return UploadFile.class.isAssignableFrom(target);
    }

    protected UploadFile[] getUploadFiles(Upload upload, Request request) {
        Multipart multiPart = request.getMultipart();
        if (multiPart == null) {
            throw new UploadSettingsRuntimeException();
        }
        if (upload == null) {
            List<UploadFile> list = multiPart.getUploadList();
            UploadFile[] files = list.toArray(new UploadFile[0]);
            return this.isFilesExist(files) ? files : new UploadFile[]{};
        }
        String uploadFileName = upload.value();
        UploadFile[] files = multiPart.getUploadMap().get(uploadFileName);
        if (this.isFilesExist(files)) {
            return files;
        }
        throw new UploadFileNotFoundException(uploadFileName);
    }

    private boolean isFilesExist(UploadFile[] files) {
        return files != null && files.length > 0;
    }
}

