/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.t2.action.parameter.impl;

import java.lang.annotation.Annotation;
import org.t2framework.commons.meta.MethodDesc;
import org.t2framework.commons.util.HtmlEscapeUtil;
import org.t2framework.commons.util.Logger;
import org.t2framework.commons.util.StringUtil;
import org.t2framework.t2.action.ActionContext;
import org.t2framework.t2.action.parameter.AbstractParameterResolver;
import org.t2framework.t2.annotation.core.RequestParam;
import org.t2framework.t2.contexts.Request;
import org.t2framework.t2.exception.InvalidRequestParameterTypeRuntimeException;
import org.t2framework.t2.exception.RequestParameterNotFoundRuntimeException;

public class RequestParamParameterResolver
extends AbstractParameterResolver {
    private static Logger logger = Logger.getLogger(RequestParamParameterResolver.class);

    public RequestParamParameterResolver() {
        this.setTargetAnnotationClass(RequestParam.class);
    }

    @Override
    public Object resolve(ActionContext actionContext, MethodDesc md, int paramIndex, Annotation[] paramAnnotations, Class<?> paramClass) {
        Request request = actionContext.getRequest();
        RequestParam requestParam = (RequestParam)this.findTargetAnnotation(paramAnnotations, this.targetAnnotationClass);
        String key = requestParam.value();
        boolean empty = requestParam.empty();
        String[] paramValues = request.getParameters(key);
        if (this.isEmpty(paramValues)) {
            if (!empty) {
                throw new RequestParameterNotFoundRuntimeException(key);
            }
            return null;
        }
        if (paramClass == String[].class) {
            String[] ret = new String[paramValues.length];
            for (int i = 0; i < paramValues.length; ++i) {
                ret[i] = HtmlEscapeUtil.escape((String)paramValues[i]);
            }
            return ret;
        }
        if (paramClass == String.class) {
            return HtmlEscapeUtil.escape((String)paramValues[0]);
        }
        if (!empty) {
            throw new InvalidRequestParameterTypeRuntimeException(paramClass);
        }
        logger.log("WTDT0018", new Object[]{paramClass.getName()});
        return null;
    }

    protected boolean isEmpty(String[] paramValues) {
        if (paramValues == null) {
            return true;
        }
        if (paramValues.length == 1) {
            return StringUtil.isEmpty((String)paramValues[0]);
        }
        return StringUtil.isAllEmpty((String[])paramValues);
    }
}

