/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.t2.action.parameter.impl;

import java.lang.annotation.Annotation;
import org.t2framework.commons.meta.MethodDesc;
import org.t2framework.commons.util.Reflections;
import org.t2framework.t2.action.ActionContext;
import org.t2framework.t2.action.ErrorInfo;
import org.t2framework.t2.action.parameter.AbstractParameterResolver;
import org.t2framework.t2.annotation.core.Form;
import org.t2framework.t2.contexts.WebContext;
import org.t2framework.t2.spi.FormResolver;
import org.t2framework.t2.spi.impl.FormResolverImpl;

public class FormParameterResolver
extends AbstractParameterResolver {
    protected static final FormResolver DEFAULT_RESOLVER = new FormResolverImpl();

    public FormParameterResolver() {
        this.setTargetAnnotationClass(Form.class);
    }

    @Override
    public Object resolve(ActionContext actionContext, MethodDesc md, int paramIndex, Annotation[] paramAnnotations, Class<?> paramClass) {
        Form form = (Form)this.findTargetAnnotation(paramAnnotations, this.targetAnnotationClass);
        if (form == null) {
            throw new IllegalStateException("@Form must not be null.");
        }
        WebContext context = WebContext.get();
        FormResolver resolver = null;
        Class<? extends FormResolver> resolverClass = form.resolverClass();
        resolver = resolverClass != FormResolverImpl.class ? context.getContainerAdapter().getComponent(resolverClass) : DEFAULT_RESOLVER;
        ErrorInfo errorInfo = actionContext.getErrorInfo();
        String className = paramClass.getName();
        Object o = null;
        try {
            o = Reflections.ClassUtil.newInstance(paramClass);
        }
        catch (Throwable t) {
            errorInfo.addErrorInfo(className, t);
            return null;
        }
        resolver.resolve(form, context, o, errorInfo);
        return o;
    }
}

