/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.t2.action.method;

import java.lang.annotation.Annotation;
import org.t2framework.commons.meta.MethodDesc;
import org.t2framework.commons.util.Assertion;
import org.t2framework.t2.action.ActionContext;
import org.t2framework.t2.action.method.ActionMethodResolver;
import org.t2framework.t2.util.UrlTemplate;
import org.t2framework.t2.util.UrlTemplateFactory;
import org.t2framework.t2.util.impl.UrlTemplateFactoryImpl;

public abstract class AbstractActionMethodResolver
implements ActionMethodResolver {
    protected UrlTemplateFactory factory = new UrlTemplateFactoryImpl();

    @Override
    public void preResolve(ActionContext actionContext, Annotation annotation, MethodDesc targetMethodDesc) {
    }

    @Override
    public void resolve(ActionContext actionContext, Annotation annotation, MethodDesc targetMethodDesc) {
        UrlTemplate template = this.getUrlTemplate(actionContext.getPageTemplatePath(), targetMethodDesc, annotation);
        actionContext.addUrlTemplate(targetMethodDesc, template);
    }

    @Override
    public void postResolve(ActionContext actionContext, Annotation annotation, MethodDesc targetMethodDesc) {
    }

    protected abstract String getTemplateValue(MethodDesc var1, Annotation var2);

    protected UrlTemplate createTemplate(String templatePath) {
        return this.factory.getUrlTemplate((String)Assertion.notNull((Object)templatePath));
    }

    public void setUrlTemplateFactory(UrlTemplateFactory factory) {
        this.factory = factory;
    }

    protected UrlTemplate getUrlTemplate(MethodDesc methodDesc, Annotation annotation) {
        Assertion.notNull((Object)methodDesc);
        Assertion.notNull((Object)annotation);
        String templatePath = this.getTemplateValue(methodDesc, annotation);
        return this.createTemplate(templatePath);
    }

    protected UrlTemplate getUrlTemplate(String prefix, MethodDesc methodDesc, Annotation annotation) {
        Assertion.notNull((Object)prefix);
        Assertion.notNull((Object)methodDesc);
        Assertion.notNull((Object)annotation);
        String templatePath = this.getTemplateValue(methodDesc, annotation);
        templatePath = !prefix.endsWith("/") && !templatePath.startsWith("/") ? prefix + "/" + templatePath : prefix + templatePath;
        return this.createTemplate(templatePath);
    }

    public UrlTemplateFactory getUrlTemplateFactory() {
        return this.factory;
    }
}

