/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.t2.action.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.t2framework.commons.util.CollectionsUtil;
import org.t2framework.t2.action.PageDescFinder;
import org.t2framework.t2.contexts.PageDesc;
import org.t2framework.t2.contexts.Request;
import org.t2framework.t2.contexts.WebContext;
import org.t2framework.t2.util.PathUtil;

public class PageDescFinderImpl
implements PageDescFinder {
    protected List<PageDesc> pageDescList;

    @Override
    public void initialize(Map<String, PageDesc> pageDescMap) {
        List list = CollectionsUtil.newArrayList();
        list.addAll(pageDescMap.values());
        Collections.sort(list, new Comparator<PageDesc>(){

            @Override
            public int compare(PageDesc o1, PageDesc o2) {
                String pageTemplatePath2 = o2.getPageTemplatePath().replaceAll("\\{.*\\}", "");
                String pageTemplatePath1 = o1.getPageTemplatePath().replaceAll("\\{.*\\}", "");
                return pageTemplatePath2.length() - pageTemplatePath1.length();
            }
        });
        this.pageDescList = list;
    }

    @Override
    public List<PageDesc> find(WebContext context) {
        ArrayList<PageDesc> ret = new ArrayList<PageDesc>();
        HttpServletRequest req = (HttpServletRequest)((Request)context.getRequest()).getNativeResource();
        String path = PathUtil.getPagePath(req.getContextPath(), req.getRequestURI());
        for (PageDesc pd : this.pageDescList) {
            if (!pd.match(path)) continue;
            ret.add(pd);
        }
        return ret;
    }
}

