/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.t2.action.impl;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.t2framework.t2.action.ActionContext;
import org.t2framework.t2.action.ActionContextBuilder;
import org.t2framework.t2.action.ActionInvokingContext;
import org.t2framework.t2.action.ActionStatus;
import org.t2framework.t2.action.impl.ActionContextBuilderImpl;
import org.t2framework.t2.action.method.ActionMethodResolver;
import org.t2framework.t2.action.parameter.ParameterResolver;
import org.t2framework.t2.adapter.ContainerAdapter;
import org.t2framework.t2.contexts.PageDesc;
import org.t2framework.t2.contexts.WebConfiguration;
import org.t2framework.t2.contexts.WebContext;
import org.t2framework.t2.plugin.PluginProcessor;
import org.t2framework.t2.spi.AnnotationResolverCreator;
import org.t2framework.t2.spi.Navigation;

public class ActionInvokingContextImpl
implements ActionInvokingContext {
    protected WebContext context;
    protected ActionStatus actionStatus = ActionStatus.NONE;
    protected Navigation navigation;
    protected AnnotationResolverCreator resolverCreator;
    protected PluginProcessor pluginProcessor;
    protected AtomicInteger count = new AtomicInteger(0);
    protected ContainerAdapter<?> containerAdapter;
    protected Object[] actionArguments;
    protected Object page;

    public ActionInvokingContextImpl(WebContext context, WebConfiguration webConfig, PluginProcessor pluginProcessor) {
        this(context, webConfig.getResolverCreator(), webConfig.getContainerAdapter(), pluginProcessor);
    }

    public ActionInvokingContextImpl(WebContext context, AnnotationResolverCreator creator, ContainerAdapter<?> containerAdapter, PluginProcessor pluginProcessor) {
        this.context = context;
        this.resolverCreator = creator;
        this.containerAdapter = containerAdapter;
        this.pluginProcessor = pluginProcessor;
    }

    @Override
    public ActionContext getActionContext() {
        return this.context.getActionContext();
    }

    @Override
    public WebContext getWebContext() {
        return this.context;
    }

    @Override
    public ActionStatus getActionStatus() {
        return this.actionStatus;
    }

    @Override
    public void setActionStatus(ActionStatus actionStatus) {
        this.actionStatus = actionStatus;
    }

    @Override
    public void setResultNavigation(Navigation navigation) {
        this.navigation = navigation;
    }

    @Override
    public Navigation getResultNavigation() {
        return this.navigation;
    }

    @Override
    public AnnotationResolverCreator getResolverCreator() {
        return this.resolverCreator;
    }

    @Override
    public ContainerAdapter<?> getContainerAdapter() {
        return this.containerAdapter;
    }

    @Override
    public PluginProcessor getPluginProcessor() {
        return this.pluginProcessor;
    }

    protected ActionContextBuilder createActionContextBuilder() {
        AnnotationResolverCreator resolverCreator = this.getResolverCreator();
        ContainerAdapter<?> containerAdapter = this.getContainerAdapter();
        return new ActionContextBuilderImpl(resolverCreator.createActionMethodResolvers(containerAdapter), resolverCreator.createDefaultActionMethodResolver(containerAdapter));
    }

    @Override
    public Object createPage(PageDesc pageDesc) {
        ContainerAdapter<?> adapter = this.getContainerAdapter();
        if (adapter != null) {
            Class componentClass = pageDesc.getPageClassDesc().getComponentClass();
            return adapter.getComponent(componentClass);
        }
        return null;
    }

    @Override
    public List<ParameterResolver> createParameterResolvers() {
        return this.getResolverCreator().createParameterResolvers(this.getContainerAdapter(), this.getWebContext());
    }

    @Override
    public synchronized ActionContext buildActionContext() {
        return this.createActionContextBuilder().build(this);
    }

    @Override
    public void nextPageDesc() {
        this.count.incrementAndGet();
    }

    @Override
    public PageDesc getCurrentPageDesc() {
        return this.getActionContext().getPageDescCandidates().get(this.count.get());
    }

    @Override
    public Object[] getActionArguments() {
        return this.actionArguments;
    }

    @Override
    public void setActionArguments(Object[] actionArguments) {
        this.actionArguments = actionArguments;
    }

    @Override
    public Object getPage() {
        return this.page;
    }

    @Override
    public void setPage(Object page) {
        this.page = page;
    }

    @Override
    public Map<Class<? extends Annotation>, ActionMethodResolver> createActionMethodResolvers() {
        return this.getResolverCreator().createActionMethodResolvers(this.getContainerAdapter());
    }

    @Override
    public ActionMethodResolver createDefaultActionMethodResolver() {
        return this.getResolverCreator().createDefaultActionMethodResolver(this.getContainerAdapter());
    }
}

