/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.t2.action.impl;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.t2framework.commons.util.ArrayUtil;
import org.t2framework.commons.util.Assertion;
import org.t2framework.commons.util.Logger;
import org.t2framework.commons.util.PrintableUtil;
import org.t2framework.t2.action.ActionContext;
import org.t2framework.t2.action.ActionFilter;
import org.t2framework.t2.action.ActionInvoker;
import org.t2framework.t2.action.ActionInvokingContext;
import org.t2framework.t2.action.ActionStatus;
import org.t2framework.t2.action.PageDescFinder;
import org.t2framework.t2.action.impl.ActionArgumentsPreparationFilterImpl;
import org.t2framework.t2.action.impl.ActionContextImpl;
import org.t2framework.t2.action.impl.ActionFilterChainImpl;
import org.t2framework.t2.action.impl.ActionInvokerFilterImpl;
import org.t2framework.t2.action.impl.ExceptionHandlerActionFilterImpl;
import org.t2framework.t2.action.impl.PageCreationFilterImpl;
import org.t2framework.t2.action.impl.PageDescFinderImpl;
import org.t2framework.t2.contexts.PageDesc;
import org.t2framework.t2.contexts.WebConfiguration;
import org.t2framework.t2.contexts.WebContext;
import org.t2framework.t2.spi.Navigation;

public class ActionInvokerImpl
implements ActionInvoker {
    protected static Logger log = Logger.getLogger(ActionInvokerImpl.class);
    protected ActionFilter[] filters = new ActionFilter[]{new ExceptionHandlerActionFilterImpl(), new PageCreationFilterImpl(), new ActionArgumentsPreparationFilterImpl(), new ActionInvokerFilterImpl()};
    protected PageDescFinder pageDescFinder = new PageDescFinderImpl();

    @Override
    public void initialize(WebConfiguration webConfiguration, Map<String, PageDesc> pageDescMap) {
        this.getPageDescFinder().initialize(pageDescMap);
    }

    @Override
    public Navigation invoke(ActionInvokingContext invokingContext) {
        PageDesc pageDesc;
        ActionFilterChainImpl chain;
        Navigation ret;
        Assertion.notNull((Object)invokingContext);
        ActionContext actionContext = this.setupActionContext(invokingContext);
        invokingContext.setActionStatus(ActionStatus.BEGIN);
        List<PageDesc> pageCandidates = actionContext.getPageDescCandidates();
        Iterator<PageDesc> i$ = pageCandidates.iterator();
        while (i$.hasNext() && !this.found(ret = (invokingContext = (chain = new ActionFilterChainImpl(this.filters)).invokeChain(invokingContext, pageDesc = i$.next())).getResultNavigation())) {
            invokingContext.nextPageDesc();
        }
        log.debug("Action status {}", new Object[]{invokingContext.getActionStatus()});
        invokingContext.setActionStatus(ActionStatus.END);
        return invokingContext.getResultNavigation();
    }

    protected boolean found(Navigation navigation) {
        return navigation != null;
    }

    protected ActionContext setupActionContext(ActionInvokingContext invokingContext) {
        WebContext context = invokingContext.getWebContext();
        ActionContext actionContext = this.createActionContext(context);
        List<PageDesc> pageDescCandidates = this.getPageDescFinder().find(context);
        if (pageDescCandidates != null) {
            Object[] args = new Object[pageDescCandidates.size()];
            for (int i = 0; i < pageDescCandidates.size(); ++i) {
                PageDesc pd = pageDescCandidates.get(i);
                args[i] = pd.getPageName();
            }
            if (0 < args.length) {
                log.log("ITDT0020", new Object[]{PrintableUtil.toPrintableString((Object[])args)});
            }
        }
        actionContext.setPageDescCandidates(pageDescCandidates);
        return actionContext;
    }

    protected ActionContext createActionContext(WebContext context) {
        ActionContextImpl actionContext = new ActionContextImpl(context);
        context.setActionContext(actionContext);
        return actionContext;
    }

    public void setActionFilters(ActionFilter[] filters) {
        this.filters = filters;
    }

    public void setActionFilter(ActionFilter filter) {
        ArrayUtil.add((Object[])this.filters, (Object)filter);
    }

    public void setPageDescFinder(PageDescFinder pageDescFinder) {
        this.pageDescFinder = (PageDescFinder)Assertion.notNull((Object)pageDescFinder);
    }

    public PageDescFinder getPageDescFinder() {
        return this.pageDescFinder;
    }
}

