/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.t2.action.impl;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.t2framework.commons.meta.MethodDesc;
import org.t2framework.commons.util.Assertion;
import org.t2framework.commons.util.CollectionsUtil;
import org.t2framework.t2.action.ActionContext;
import org.t2framework.t2.action.ErrorInfo;
import org.t2framework.t2.contexts.Application;
import org.t2framework.t2.contexts.PageDesc;
import org.t2framework.t2.contexts.Request;
import org.t2framework.t2.contexts.Response;
import org.t2framework.t2.contexts.Session;
import org.t2framework.t2.contexts.WebContext;
import org.t2framework.t2.util.UrlTemplate;

public class ActionContextImpl
implements ActionContext {
    protected PageDesc targetPageDesc;
    protected MethodDesc targetMethodDesc;
    protected final WebContext context;
    protected AtomicInteger matchCount = new AtomicInteger(0);
    protected Object body;
    protected List<PageDesc> pageDescCandidates;
    protected PageDesc pageDesc;
    protected ConcurrentHashMap<Method, List<UrlTemplate>> templatesMap = new ConcurrentHashMap();
    protected ErrorInfo errorInfo;

    public ActionContextImpl(WebContext context) {
        this.context = context;
    }

    public ActionContextImpl(WebContext context, PageDesc pageDesc) {
        this.context = context;
        this.pageDesc = pageDesc;
        this.pageDescCandidates = Arrays.asList(this.pageDesc);
    }

    @Override
    public MethodDesc getTargetMethodDesc() {
        if (this.targetMethodDesc == null) {
            throw new IllegalStateException("target method desc is not set yet.");
        }
        return this.targetMethodDesc;
    }

    @Override
    public synchronized void setTargetMethodDesc(MethodDesc methodDesc) {
        this.targetMethodDesc = methodDesc;
    }

    @Override
    public String getPageTemplatePath() {
        return this.getTargetPageDesc().getPageTemplatePath();
    }

    @Override
    public Request getRequest() {
        return (Request)this.context.getRequest();
    }

    @Override
    public void incrementMatchCount() {
        this.matchCount.incrementAndGet();
    }

    @Override
    public void clearMatchCount() {
        this.matchCount.set(0);
    }

    @Override
    public int getMatchCount() {
        return this.matchCount.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addUrlTemplate(MethodDesc methodDesc, UrlTemplate template) {
        Assertion.notNull((Object)methodDesc);
        Assertion.notNull((Object)template);
        Method key = methodDesc.getMethod();
        List list = this.templatesMap.get(key);
        if (list == null) {
            list = CollectionsUtil.newArrayList();
        }
        List list2 = list;
        synchronized (list2) {
            list.add(template);
            this.templatesMap.put(key, list);
        }
    }

    @Override
    public UrlTemplate[] getUrlTemplates() {
        return this.getUrlTemplates(this.getTargetMethodDesc());
    }

    @Override
    public UrlTemplate[] getUrlTemplates(MethodDesc methodDesc) {
        Assertion.notNull((Object)methodDesc);
        Method key = methodDesc.getMethod();
        List<UrlTemplate> templates = this.templatesMap.get(key);
        if (templates == null) {
            return null;
        }
        return templates.toArray(new UrlTemplate[0]);
    }

    @Override
    public Response getResponse() {
        return (Response)this.context.getResponse();
    }

    @Override
    public Session getSession() {
        return (Session)this.context.getSession();
    }

    @Override
    public Application getApplication() {
        return (Application)this.context.getApplication();
    }

    @Override
    public void setErrorInfo(ErrorInfo errorInfo) {
        this.errorInfo = (ErrorInfo)Assertion.notNull((Object)errorInfo);
    }

    @Override
    public void clearErrorInfo() {
        this.errorInfo = null;
    }

    @Override
    public ErrorInfo getErrorInfo() {
        return this.errorInfo;
    }

    @Override
    public void setPageDescCandidates(List<PageDesc> pageDescCandidates) {
        this.pageDescCandidates = pageDescCandidates;
    }

    @Override
    public List<PageDesc> getPageDescCandidates() {
        return this.pageDescCandidates;
    }

    @Override
    public boolean hasPageDescCandidates() {
        return this.getPageDescCandidates() != null && !this.getPageDescCandidates().isEmpty();
    }

    @Override
    public PageDesc getTargetPageDesc() {
        if (this.pageDesc == null) {
            throw new IllegalStateException("no such page.");
        }
        return this.pageDesc;
    }

    @Override
    public void setTargetPageDesc(PageDesc pageDesc) {
        this.pageDesc = pageDesc;
    }
}

