/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.t2.action.impl;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import org.t2framework.commons.meta.Config;
import org.t2framework.commons.meta.MethodDesc;
import org.t2framework.commons.util.Assertion;
import org.t2framework.commons.util.CollectionsUtil;
import org.t2framework.t2.action.ActionContext;
import org.t2framework.t2.action.ActionContextBuilder;
import org.t2framework.t2.action.ActionInvokingContext;
import org.t2framework.t2.action.ActionStatus;
import org.t2framework.t2.action.method.ActionMethodResolver;
import org.t2framework.t2.contexts.PageDesc;
import org.t2framework.t2.exception.NoActionMethodFoundRuntimeException;
import org.t2framework.t2.exception.NoDefaultActionMethodFoundRuntimeException;

public class ActionContextBuilderImpl
implements ActionContextBuilder {
    protected Map<Class<? extends Annotation>, ActionMethodResolver> methodResolvers = CollectionsUtil.newHashMap();
    protected ActionMethodResolver defaultResolver;

    public ActionContextBuilderImpl(Map<Class<? extends Annotation>, ActionMethodResolver> methodResolvers, ActionMethodResolver defaultResolver) {
        this.methodResolvers = (Map)Assertion.notNull(methodResolvers);
        this.defaultResolver = (ActionMethodResolver)Assertion.notNull((Object)defaultResolver);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ActionContext build(ActionInvokingContext invokingActionContext) throws NoActionMethodFoundRuntimeException {
        Assertion.notNull((Object)invokingActionContext);
        PageDesc current = invokingActionContext.getCurrentPageDesc();
        ActionContext actionContext = invokingActionContext.getActionContext();
        actionContext.setTargetPageDesc(current);
        List matchList = null;
        int maxMatchCount = 0;
        for (MethodDesc methodDesc : current.getActionMethodDesc()) {
            actionContext.clearMatchCount();
            BuildStatus buildStatus = this.buildActionMethod(actionContext, methodDesc);
            if (BuildStatus.isContinue(buildStatus)) continue;
            int matchCount = actionContext.getMatchCount();
            if (maxMatchCount < matchCount) {
                maxMatchCount = matchCount;
                matchList = CollectionsUtil.newArrayList();
                matchList.add(methodDesc);
                continue;
            }
            if (matchCount != maxMatchCount || matchList == null) continue;
            matchList.add(methodDesc);
        }
        MethodDesc methodDesc = null;
        if (matchList != null) {
            if (0 >= matchList.size()) throw new NoActionMethodFoundRuntimeException(current.getActionMethodDesc().getMethodNames());
            methodDesc = (MethodDesc)matchList.get(0);
        } else {
            methodDesc = current.getDefaultMethodDesc();
            this.setupForDefaultMethodDesc(actionContext, current, methodDesc);
        }
        invokingActionContext.setActionStatus(ActionStatus.FOUND_ACTION_METHOD);
        actionContext.setTargetMethodDesc(methodDesc);
        return actionContext;
    }

    protected BuildStatus buildActionMethod(ActionContext actionContext, MethodDesc methodDesc) {
        BuildStatus ret = BuildStatus.END;
        for (Config config : methodDesc) {
            boolean match;
            Annotation annotation;
            ActionMethodResolver resolver;
            if (!config.hasAnnotation() || (resolver = this.findAnnotationResolver(annotation = config.getAnnotation())) == null || (match = this.buildActionMethodByResolver(resolver, actionContext, annotation, methodDesc))) continue;
            ret = BuildStatus.CONTINE;
            break;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean buildActionMethodByResolver(ActionMethodResolver resolver, ActionContext actionContext, Annotation annotation, MethodDesc methodDesc) {
        resolver.preResolve(actionContext, annotation, methodDesc);
        boolean match = false;
        try {
            match = resolver.isMatch(actionContext, annotation, methodDesc);
            if (match) {
                actionContext.incrementMatchCount();
                resolver.resolve(actionContext, annotation, methodDesc);
            }
        }
        finally {
            resolver.postResolve(actionContext, annotation, methodDesc);
        }
        return match;
    }

    protected void setupForDefaultMethodDesc(ActionContext actionContext, PageDesc current, MethodDesc methodDesc) {
        if (!current.hasDefaultMethodDesc()) {
            throw new NoDefaultActionMethodFoundRuntimeException();
        }
        this.defaultResolver.resolve(actionContext, current.getDefaultAnnotation(), methodDesc);
    }

    protected ActionMethodResolver findAnnotationResolver(Annotation annotation) {
        Assertion.notNull((Object)annotation);
        return this.methodResolvers.get(annotation.annotationType());
    }

    @Override
    public void setDefaultActionAnnotationResolver(ActionMethodResolver defaultResolver) {
        this.defaultResolver = (ActionMethodResolver)Assertion.notNull((Object)defaultResolver);
    }

    @Override
    public void addActionAnnotationResolver(Class<? extends Annotation> annotationClass, ActionMethodResolver resolver) {
        this.methodResolvers.put(annotationClass, resolver);
    }

    protected static enum BuildStatus {
        CONTINE,
        END;


        public static boolean isContinue(BuildStatus buildStatus) {
            return buildStatus != null && buildStatus == CONTINE;
        }
    }
}

